/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.intentions.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.intentions.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GroovyPointlessBooleanInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("pointless.boolean.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBooleanExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof GrBinaryExpression) {
            return GroovyInspectionBundle.message("pointless.boolean.problem.descriptor", GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression((GrBinaryExpression)args[0]));
        }
        return GroovyInspectionBundle.message("pointless.boolean.problem.descriptor", GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression((GrUnaryExpression)args[0]));
    }

    @Nullable
    private static String calculateSimplifiedBinaryExpression(GrBinaryExpression expression) {
        IElementType sign = expression.getOperationTokenType();
        GrExpression lhs = expression.getLeftOperand();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return null;
        }
        String rhsText = rhs.getText();
        String lhsText = lhs.getText();
        assert (sign != null);
        if (sign.equals(GroovyTokenTypes.mLAND)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyTokenTypes.mLOR)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            return lhsText;
        }
        if (sign.equals(GroovyTokenTypes.mBXOR) || sign.equals(GroovyTokenTypes.mNOT_EQUAL)) {
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        if (sign.equals(GroovyTokenTypes.mEQUAL)) {
            if (GroovyPointlessBooleanInspection.isTrue(lhs)) {
                return rhsText;
            }
            if (GroovyPointlessBooleanInspection.isTrue(rhs)) {
                return lhsText;
            }
            if (GroovyPointlessBooleanInspection.isFalse(lhs)) {
                return GroovyPointlessBooleanInspection.createStringForNegatedExpression(rhs);
            }
            return GroovyPointlessBooleanInspection.createStringForNegatedExpression(lhs);
        }
        return "";
    }

    private static String createStringForNegatedExpression(GrExpression exp) {
        if (ComparisonUtils.isComparison(exp)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)exp;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        String baseText = exp.getText();
        if (ParenthesesUtils.getPrecedence(exp) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + baseText + ')';
        }
        return '!' + baseText;
    }

    @NonNls
    private static String calculateSimplifiedPrefixExpression(GrUnaryExpression expression) {
        GrExpression operand = expression.getOperand();
        if (GroovyPointlessBooleanInspection.isTrue(operand)) {
            return "false";
        }
        return "true";
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new BooleanLiteralComparisonFix();
    }

    private static boolean equalityExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return (GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isFalse(lhs)) && GroovyPointlessBooleanInspection.isBoolean(rhs) || (GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(rhs)) && GroovyPointlessBooleanInspection.isBoolean(lhs);
    }

    private static boolean isBoolean(GrExpression expression) {
        PsiType type = expression.getType();
        PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type);
        return unboxed != null && PsiType.BOOLEAN.equals((Object)unboxed);
    }

    private static boolean andExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs);
    }

    private static boolean orExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean xorExpressionIsPointless(GrExpression lhs, GrExpression rhs) {
        return GroovyPointlessBooleanInspection.isTrue(lhs) || GroovyPointlessBooleanInspection.isTrue(rhs) || GroovyPointlessBooleanInspection.isFalse(lhs) || GroovyPointlessBooleanInspection.isFalse(rhs);
    }

    private static boolean notExpressionIsPointless(GrExpression arg) {
        return GroovyPointlessBooleanInspection.isFalse(arg) || GroovyPointlessBooleanInspection.isTrue(arg);
    }

    private static boolean isTrue(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        String text = expression.getText();
        return "true".equals(text);
    }

    private static boolean isFalse(GrExpression expression) {
        if (expression == null) {
            return false;
        }
        if (!(expression instanceof GrLiteral)) {
            return false;
        }
        String text = expression.getText();
        return "false".equals(text);
    }

    private static class PointlessBooleanExpressionVisitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> booleanTokens = new HashSet<IElementType>(5);

        private PointlessBooleanExpressionVisitor() {
            this.booleanTokens.add(GroovyTokenTypes.mLAND);
            this.booleanTokens.add(GroovyTokenTypes.mLOR);
            this.booleanTokens.add(GroovyTokenTypes.mBXOR);
            this.booleanTokens.add(GroovyTokenTypes.mEQUAL);
            this.booleanTokens.add(GroovyTokenTypes.mNOT_EQUAL);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$PointlessBooleanExpressionVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!this.booleanTokens.contains(sign)) {
                return;
            }
            GrExpression lhs = expression.getLeftOperand();
            assert (sign != null);
            boolean isPointless = sign.equals(GroovyTokenTypes.mEQUAL) || sign.equals(GroovyTokenTypes.mNOT_EQUAL) ? GroovyPointlessBooleanInspection.equalityExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mLAND) ? GroovyPointlessBooleanInspection.andExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mLOR) ? GroovyPointlessBooleanInspection.orExpressionIsPointless(lhs, rhs) : (sign.equals(GroovyTokenTypes.mBXOR) ? GroovyPointlessBooleanInspection.xorExpressionIsPointless(lhs, rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$PointlessBooleanExpressionVisitor", "visitUnaryExpression"));
            }
            super.visitUnaryExpression(expression);
            IElementType sign = expression.getOperationTokenType();
            if (sign == null) {
                return;
            }
            GrExpression operand = expression.getOperand();
            if (sign.equals(GroovyTokenTypes.mLNOT) && GroovyPointlessBooleanInspection.notExpressionIsPointless(operand)) {
                this.registerError(expression);
            }
        }
    }

    private static class BooleanLiteralComparisonFix
    extends GroovyFix {
        private BooleanLiteralComparisonFix() {
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("pointless.boolean.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyPointlessBooleanInspection$BooleanLiteralComparisonFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof GrBinaryExpression) {
                GrBinaryExpression expression = (GrBinaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedBinaryExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            } else {
                GrUnaryExpression expression = (GrUnaryExpression)element;
                String replacementString = GroovyPointlessBooleanInspection.calculateSimplifiedPrefixExpression(expression);
                BooleanLiteralComparisonFix.replaceExpression(expression, replacementString);
            }
        }
    }
}

