/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAccessibilityInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.codeInspection.bugs.GroovyAccessibilityInspection");

    public static boolean isStaticallyImportedProperty(GroovyResolveResult result, GrReferenceElement place) {
        PsiElement parent = place.getParent();
        if (!(parent instanceof GrImportStatement)) {
            return false;
        }
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiMethod getter = GroovyPropertyUtils.findGetterForField((PsiField)resolved);
        PsiMethod setter = GroovyPropertyUtils.findSetterForField((PsiField)resolved);
        return getter != null && PsiUtil.isAccessible(place, (PsiMember)getter) || setter != null && PsiUtil.isAccessible(place, (PsiMember)setter);
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("access.to.inaccessible.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("cannot.access", args);
    }

    @Override
    protected GroovyFix[] buildFixes(@NotNull PsiElement location) {
        GroovyResolveResult resolveResult;
        PsiElement element;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection", "buildFixes"));
        }
        if (!(location instanceof GrReferenceElement) && !(location instanceof GrConstructorCall)) {
            location = location.getParent();
        }
        if (!((element = (resolveResult = location instanceof GrConstructorCall ? ((GrConstructorCall)location).advancedResolve() : ((GrReferenceElement)location).advancedResolve()).getElement()) instanceof PsiMember)) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiMember refElement = (PsiMember)element;
        if (refElement instanceof PsiCompiledElement) {
            return GroovyFix.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return GroovyFix.EMPTY_ARRAY;
        }
        ArrayList<GrModifierFix> fixes = new ArrayList<GrModifierFix>();
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            assert (modifierListCopy != null);
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "protected";
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"protected", "public", "packageLocal"};
            PsiClass accessObjectClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)location, PsiClass.class, (boolean)false);
            if (accessObjectClass == null) {
                PsiFile file = location.getContainingFile();
                if (!(file instanceof GroovyFile)) {
                    return GroovyFix.EMPTY_ARRAY;
                }
                accessObjectClass = ((GroovyFile)file).getScriptClass();
            }
            for (int i = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i < modifiers.length; ++i) {
                Object modifier = modifiers[i];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, location, accessObjectClass, null)) continue;
                fixes.add(new GrModifierFix(refElement, (String)modifier, true, true, new Function<ProblemDescriptor, PsiModifierList>(){

                    public PsiModifierList fun(ProblemDescriptor descriptor) {
                        PsiElement element = descriptor.getPsiElement();
                        assert (element instanceof GrReferenceElement) : element;
                        PsiElement resolved = ((GrReferenceElement)element).resolve();
                        assert (resolved instanceof PsiModifierListOwner) : resolved;
                        return ((PsiModifierListOwner)resolved).getModifierList();
                    }
                }));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return fixes.toArray(new GroovyFix[fixes.size()]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
            super.visitCodeReferenceElement(refElement);
            this.checkRef(refElement);
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression ref) {
            super.visitReferenceExpression(ref);
            if (!(ref.getParent() instanceof GrConstructorInvocation)) {
                this.checkRef(ref);
            }
        }

        @Override
        public void visitNewExpression(GrNewExpression newExpression) {
            this.checkConstructorCall(newExpression);
        }

        private void checkConstructorCall(GrConstructorCall call) {
            GroovyResolveResult result = call.advancedResolve();
            if (result.getElement() == null) {
                return;
            }
            PsiElement constructor = result.getElement();
            if (!(constructor instanceof PsiMethod)) {
                return;
            }
            if (!result.isAccessible()) {
                GroovyPsiElement refElement = null;
                if (call instanceof GrNewExpression) {
                    refElement = ((GrNewExpression)call).getReferenceElement();
                } else if (call instanceof GrConstructorInvocation) {
                    refElement = ((GrConstructorInvocation)call).getInvokedExpression();
                }
                if (refElement == null) {
                    refElement = call;
                }
                this.registerError((PsiElement)refElement, PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)constructor), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2));
            }
        }

        @Override
        public void visitConstructorInvocation(GrConstructorInvocation invocation) {
            super.visitConstructorInvocation(invocation);
            this.checkConstructorCall(invocation);
        }

        private void checkRef(GrReferenceElement ref) {
            GroovyResolveResult result = ref.advancedResolve();
            if (result == null) {
                return;
            }
            if (result.getElement() == null) {
                return;
            }
            if (!result.isAccessible() && !GroovyAccessibilityInspection.isStaticallyImportedProperty(result, ref)) {
                this.registerError(MyVisitor.getErrorLocation(ref), ref.getReferenceName());
            }
        }

        @NotNull
        private static PsiElement getErrorLocation(GrReferenceElement ref) {
            PsiElement nameElement = ref.getReferenceNameElement();
            if (nameElement != null) {
                PsiElement psiElement = nameElement;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection$MyVisitor", "getErrorLocation"));
                }
                return psiElement;
            }
            GrReferenceElement grReferenceElement = ref;
            if (grReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyAccessibilityInspection$MyVisitor", "getErrorLocation"));
            }
            return grReferenceElement;
        }
    }
}

