/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ParameterCastFix
extends GroovyFix {
    private final GrExpression myArgument;
    private final PsiType myType;
    private String myName;

    public ParameterCastFix(int param, @NotNull PsiType type, @NotNull GrExpression argument) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix", "<init>"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix", "<init>"));
        }
        this.myArgument = argument;
        this.myType = PsiImplUtil.normalizeWildcardTypeByPosition(type, argument);
        StringBuilder builder = new StringBuilder();
        builder.append("Cast ");
        builder.append(param + 1);
        switch (param + 1) {
            case 1: {
                builder.append("st");
                break;
            }
            case 2: {
                builder.append("nd");
                break;
            }
            case 3: {
                builder.append("rd");
                break;
            }
            default: {
                builder.append("th");
            }
        }
        builder.append(" parameter to ").append(this.myType.getPresentableText());
        this.myName = builder.toString();
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrArgumentList list;
        PsiElement element = descriptor.getPsiElement();
        GrArgumentList grArgumentList = list = element instanceof GrArgumentList ? (GrArgumentList)element : PsiUtil.getArgumentsList(element);
        if (list == null) {
            return;
        }
        GrCastFix.doCast(project, this.myType, this.myArgument);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/ParameterCastFix", "getName"));
        }
        return string;
    }
}

