/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyUncheckedAssignmentOfMemberOfRawTypeInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyUncheckedAssignmentOfMemberOfRawTypeInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        PsiType expectedType = (PsiType)args[0];
        PsiType rType = (PsiType)args[1];
        return GroovyBundle.message("cannot.assign", rType.getPresentableText(), expectedType.getPresentableText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyUncheckedAssignmentOfMemberOfRawTypeInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unchecked assignment from members of raw type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyUncheckedAssignmentOfMemberOfRawTypeInspection", "getDisplayName"));
        }
        return "Unchecked assignment from members of raw type";
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            PsiMethod method;
            GrParametersOwner owner;
            PsiType type;
            GrExpression value = returnStatement.getReturnValue();
            if (value != null && (type = value.getType()) != null && (owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class})) instanceof PsiMethod && !(method = (PsiMethod)owner).isConstructor()) {
                PsiType methodType = method.getReturnType();
                PsiType returnType = value.getType();
                if (methodType != null && !PsiType.VOID.equals((Object)methodType) && returnType != null) {
                    this.checkAssignability(methodType, value, value);
                }
            }
        }

        @Override
        public void visitNamedArgument(GrNamedArgument argument) {
            PsiType expectedType;
            GrArgumentLabel label = argument.getLabel();
            if (label != null && (expectedType = label.getExpectedArgumentType()) != null) {
                PsiType argType;
                expectedType = TypeConversionUtil.erasure((PsiType)expectedType);
                GrExpression expr = argument.getExpression();
                if (expr != null && (argType = expr.getType()) != null) {
                    PsiClassType listType = JavaPsiFacade.getInstance((Project)argument.getProject()).getElementFactory().createTypeByFQClassName("java.util.List", argument.getResolveScope());
                    if (listType.isAssignableFrom(argType)) {
                        return;
                    }
                    this.checkAssignability(expectedType, expr, argument);
                }
            }
        }

        @Override
        public void visitVariable(GrVariable variable) {
            PsiType rType;
            PsiType varType = variable.getType();
            GrExpression initializer = variable.getInitializerGroovy();
            if (initializer != null && (rType = initializer.getType()) != null) {
                this.checkAssignability(varType, initializer, initializer);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyUncheckedAssignmentOfMemberOfRawTypeInspection$Visitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(assignment);
            GrExpression lValue = assignment.getLValue();
            if (!PsiUtil.mightBeLValue(lValue)) {
                return;
            }
            IElementType opToken = assignment.getOperationTokenType();
            if (opToken != GroovyTokenTypes.mASSIGN) {
                return;
            }
            GrExpression rValue = assignment.getRValue();
            if (rValue == null) {
                return;
            }
            PsiType lType = lValue.getNominalType();
            PsiType rType = rValue.getType();
            if (GroovyRefactoringUtil.isSpreadAssignment(lValue) && lType != null && lType instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType pct = (PsiClassType)lType;
                PsiClass clazz = pct.resolve();
                if (clazz != null && "java.util.List".equals(clazz.getQualifiedName()) && (types = pct.getParameters()).length == 1 && types[0] != null && rType != null) {
                    this.checkAssignability(types[0], rValue, assignment);
                }
                return;
            }
            if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                return;
            }
            if (lType != null && rType != null) {
                this.checkAssignability(lType, rValue, rValue);
            }
        }

        private void checkAssignability(PsiType lType, GrExpression rExpr, GroovyPsiElement element) {
            PsiType rType;
            if (PsiUtil.isRawClassMemberAccess(rExpr) && !TypesUtil.isAssignable(lType, rType = rExpr.getType(), element)) {
                this.registerError((PsiElement)element, lType, rType);
            }
        }
    }
}

