/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.DelegatingCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrBinaryExprInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrConstructorInvocationInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrEnumConstantInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrIndexPropertyInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrListOrMapInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrMethodCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrNewExpressionInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ParameterCastFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyAssignabilityCheckInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(GroovyAssignabilityCheckInspection.class);
    private static final String SHORT_NAME = "GroovyAssignabilityCheck";
    public boolean myHighlightAssignmentsFromVoid = true;
    private static final ThreadLocal<AnnotatingVisitor> visitor = new ThreadLocal<AnnotatingVisitor>(){

        @Override
        protected AnnotatingVisitor initialValue() {
            return new AnnotatingVisitor();
        }
    };

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Assignment issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "getGroupDisplayName"));
        }
        return "Assignment issues";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("highlight.assignments.from.void", new Object[0]), "myHighlightAssignmentsFromVoid");
        return optionsPanel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Incompatible type assignments" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "getDisplayName"));
        }
        return "Incompatible type assignments";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return (String)args[0];
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Nullable
    private static List<GrExpression> getExpressionArgumentsOfCall(@NotNull GrArgumentList argumentList) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "getExpressionArgumentsOfCall"));
        }
        GrExpression[] argArray = argumentList.getExpressionArguments();
        ArrayList args = ContainerUtil.newArrayList();
        for (GrExpression arg : argArray) {
            if (arg instanceof GrSpreadArgument) {
                GrExpression spreaded = ((GrSpreadArgument)arg).getArgument();
                if (spreaded instanceof GrListOrMap && !((GrListOrMap)spreaded).isMap()) {
                    Collections.addAll(args, ((GrListOrMap)spreaded).getInitializers());
                    continue;
                }
                return null;
            }
            args.add(arg);
        }
        PsiElement parent = argumentList.getParent();
        if (parent instanceof GrIndexProperty && PsiUtil.isLValue((GroovyPsiElement)parent)) {
            args.add(TypeInferenceHelper.getInitializerFor((GrExpression)parent));
        } else if (parent instanceof GrMethodCallExpression) {
            ContainerUtil.addAll((Collection)args, (Object[])((GrMethodCallExpression)parent).getClosureArguments());
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkElement(GroovyPsiElement e, AnnotationHolder holder) {
        AnnotatingVisitor annotatingVisitor = visitor.get();
        AnnotationHolder oldHolder = annotatingVisitor.myHolder;
        try {
            annotatingVisitor.myHolder = holder;
            e.accept(annotatingVisitor);
        }
        finally {
            annotatingVisitor.myHolder = oldHolder;
        }
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "checkFile"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "checkFile"));
        }
        if (!(psiFile instanceof GroovyFileBase)) {
            return super.checkFile(psiFile, inspectionManager, isOnTheFly);
        }
        GroovyFileBase groovyFile = (GroovyFileBase)psiFile;
        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, psiFile, isOnTheFly);
        MyVisitor visitor = (MyVisitor)this.buildGroovyVisitor(problemsHolder, isOnTheFly);
        GroovyAssignabilityCheckInspection.processElement(groovyFile, visitor);
        return problemsHolder.getResultsArray();
    }

    private static void processElement(@NotNull GroovyPsiElement element, @NotNull MyVisitor visitor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "processElement"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection", "processElement"));
        }
        if (element instanceof GrMember && !visitor.shouldProcess((GrMember)element)) {
            return;
        }
        int count = visitor.getErrorCount();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            GroovyAssignabilityCheckInspection.processElement((GroovyPsiElement)child, visitor);
        }
        if (count == visitor.getErrorCount()) {
            element.accept(visitor);
        }
    }

    private static class AnnotatingVisitor
    extends MyVisitor {
        private AnnotationHolder myHolder;

        private AnnotatingVisitor() {
        }

        @Override
        protected boolean shouldProcess(GrMember member) {
            return true;
        }

        @Override
        protected void registerError(final @NotNull PsiElement location, final @NotNull String description, final @Nullable LocalQuickFix[] fixes, final ProblemHighlightType highlightType) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor", "registerError"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor", "registerError"));
            }
            Annotation annotation = this.myHolder.createErrorAnnotation(location, description);
            if (fixes != null) {
                for (final LocalQuickFix fix : fixes) {
                    annotation.registerFix(new IntentionAction(){

                        @NotNull
                        public String getText() {
                            String string = fix.getName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor$1", "getText"));
                            }
                            return string;
                        }

                        @NotNull
                        public String getFamilyName() {
                            String string = fix.getFamilyName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor$1", "getFamilyName"));
                            }
                            return string;
                        }

                        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor$1", "isAvailable"));
                            }
                            return true;
                        }

                        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor$1", "invoke"));
                            }
                            InspectionManager manager = InspectionManager.getInstance((Project)project);
                            ProblemDescriptor descriptor = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
                            fix.applyFix(project, (CommonProblemDescriptor)descriptor);
                        }

                        public boolean startInWriteAction() {
                            return true;
                        }
                    });
                }
            }
        }

        @Override
        protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$AnnotatingVisitor", "registerError"));
            }
            this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
        }
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        private void checkAssignability(@NotNull PsiType expectedType, @NotNull GrExpression expression, PsiElement toHighlight) {
            if (expectedType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkAssignability"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkAssignability"));
            }
            if (PsiUtil.isRawClassMemberAccess(expression)) {
                return;
            }
            if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
                return;
            }
            PsiType rType = expression.getType();
            if (rType == null) {
                return;
            }
            if (PsiUtil.isVoidMethodCall(expression)) {
                if (MyVisitor.isHighlightAssignmentsFromVoid(expression)) {
                    this.registerError(toHighlight, GroovyBundle.message("cannot.assign", PsiType.VOID.getPresentableText(), expectedType.getPresentableText()));
                }
                return;
            }
            if (!TypesUtil.isAssignable(expectedType, rType, expression)) {
                ArrayList fixes = ContainerUtil.newArrayList();
                fixes.add(new GrCastFix(expectedType, expression));
                String varName = MyVisitor.getLValueVarName(toHighlight);
                if (varName != null) {
                    fixes.add(new GrChangeVariableType(rType, varName));
                }
                String message = GroovyBundle.message("cannot.assign", rType.getPresentableText(), expectedType.getPresentableText());
                this.registerError(toHighlight, message, fixes.toArray(new LocalQuickFix[fixes.size()]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private static boolean isHighlightAssignmentsFromVoid(PsiElement place) {
            GroovyAssignabilityCheckInspection instance = MyVisitor.getInspectionInstance(place.getContainingFile(), place.getProject());
            if (instance != null) {
                return instance.myHighlightAssignmentsFromVoid;
            }
            return false;
        }

        private static GroovyAssignabilityCheckInspection getInspectionInstance(PsiFile file, Project project) {
            InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
            return (GroovyAssignabilityCheckInspection)profile.getUnwrappedTool(GroovyAssignabilityCheckInspection.SHORT_NAME, (PsiElement)file);
        }

        @Nullable
        private static String getLValueVarName(PsiElement highlight) {
            PsiElement resolved;
            PsiElement parent = highlight.getParent();
            if (parent instanceof GrVariable) {
                return ((GrVariable)parent).getName();
            }
            if (highlight instanceof GrReferenceExpression && parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == highlight && (resolved = ((GrReferenceExpression)highlight).resolve()) instanceof GrVariable && GroovyRefactoringUtil.isLocalVariable(resolved)) {
                return ((GrVariable)resolved).getName();
            }
            return null;
        }

        private void checkAssignability(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull GroovyPsiElement context, @NotNull PsiElement elementToHighlight) {
            if (lType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkAssignability"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkAssignability"));
            }
            if (elementToHighlight == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkAssignability"));
            }
            if (rType == null) {
                return;
            }
            if (!TypesUtil.isAssignable(lType, rType, context)) {
                String message = GroovyBundle.message("cannot.assign", rType.getPresentableText(), lType.getPresentableText());
                this.registerError(elementToHighlight, message, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        private boolean checkForImplicitEnumAssigning(PsiType expectedType, GrExpression expression, GroovyPsiElement element) {
            if (!(expectedType instanceof PsiClassType)) {
                return false;
            }
            if (!GroovyConfigUtils.getInstance().isVersionAtLeast(element, "1.8")) {
                return false;
            }
            PsiClass resolved = ((PsiClassType)expectedType).resolve();
            if (resolved == null || !resolved.isEnum()) {
                return false;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            if (!type.equalsToText("groovy.lang.GString") && !type.equalsToText("java.lang.String")) {
                return false;
            }
            Object result = GroovyConstantExpressionEvaluator.evaluate(expression);
            if (result == null || !(result instanceof String)) {
                this.registerError((PsiElement)element, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
            } else {
                PsiField field = resolved.findFieldByName((String)result, true);
                if (!(field instanceof PsiEnumConstant)) {
                    this.registerError((PsiElement)element, GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result, expectedType.getPresentableText()));
                }
            }
            return true;
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            GrExpression value = returnStatement.getReturnValue();
            if (value == null || MyVisitor.isNewInstanceInitialingByTuple(value)) {
                return;
            }
            PsiType returnType = PsiImplUtil.inferReturnType(returnStatement);
            if (returnType != null) {
                this.checkAssignability(returnType, value, returnStatement.getReturnWord());
            }
        }

        @Override
        public void visitExpression(GrExpression expression) {
            if (PsiUtil.isExpressionStatement(expression)) {
                PsiType returnType = PsiImplUtil.inferReturnType(expression);
                GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(expression);
                if (flowOwner != null && returnType != null && returnType != PsiType.VOID && ControlFlowUtils.isReturnValue(expression, flowOwner) && !MyVisitor.isNewInstanceInitialingByTuple(expression) && !PsiUtil.isVoidMethodCall(expression)) {
                    this.checkAssignability(returnType, expression, MyVisitor.getExpressionPartToHighlight(expression));
                }
            }
        }

        protected boolean shouldProcess(GrMember member) {
            return !GroovyPsiManager.getInstance(member.getProject()).isCompileStatic(member);
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression assignment) {
            GrExpression lValue = assignment.getLValue();
            if (lValue instanceof GrIndexProperty) {
                return;
            }
            if (!PsiUtil.mightBeLValue(lValue)) {
                return;
            }
            IElementType opToken = assignment.getOperationTokenType();
            if (opToken != GroovyTokenTypes.mASSIGN) {
                return;
            }
            GrExpression rValue = assignment.getRValue();
            if (rValue == null) {
                return;
            }
            if (lValue instanceof GrTupleExpression) {
                this.checkTupleAssignment((GrTupleExpression)lValue, rValue);
            } else {
                this.checkAssignment(lValue, rValue);
            }
        }

        private void checkTupleAssignment(GrTupleExpression tupleExpression, GrExpression initializer) {
            GrExpression[] lValues = tupleExpression.getExpressions();
            if (initializer instanceof GrListOrMap) {
                GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
                for (int i = 0; i < lValues.length; ++i) {
                    GrExpression lValue = lValues[i];
                    if (initializers.length < i) {
                        GrExpression rValue = initializers[i];
                        this.checkAssignment(lValue, rValue);
                        continue;
                    }
                    break;
                }
            } else {
                PsiType type = initializer.getType();
                PsiType rType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                for (GrExpression lValue : lValues) {
                    PsiType lType = lValue.getNominalType();
                    if (GroovyRefactoringUtil.isSpreadAssignment(lValue)) {
                        PsiType argType = MyVisitor.extractIterableArg(lType);
                        if (argType != null && rType != null) {
                            this.checkAssignability(argType, rType, tupleExpression, MyVisitor.getExpressionPartToHighlight(lValue));
                        }
                        return;
                    }
                    if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                        return;
                    }
                    if (lType == null || rType == null) continue;
                    this.checkAssignability(lType, rType, tupleExpression, MyVisitor.getExpressionPartToHighlight(lValue));
                }
            }
        }

        private void checkAssignment(GrExpression lValue, GrExpression rValue) {
            PsiType lType = lValue.getNominalType();
            PsiType rType = rValue.getType();
            if (GroovyRefactoringUtil.isSpreadAssignment(lValue)) {
                PsiType argType = MyVisitor.extractIterableArg(lType);
                if (argType != null && rValue != null) {
                    this.checkAssignability(argType, rValue, MyVisitor.getExpressionPartToHighlight(lValue));
                }
                return;
            }
            if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                return;
            }
            if (MyVisitor.isNewInstanceInitialingByTuple(rValue)) {
                return;
            }
            if (lType != null && rType != null) {
                this.checkAssignability(lType, rValue, MyVisitor.getExpressionPartToHighlight(lValue));
            }
        }

        @Nullable
        private static PsiType extractIterableArg(@Nullable PsiType type) {
            return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
        }

        @Override
        public void visitVariable(GrVariable variable) {
            GrExpression initializer;
            PsiType varType = variable.getType();
            PsiElement parent = variable.getParent();
            if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).isTuple()) {
                GrVariableDeclaration tuple = (GrVariableDeclaration)parent;
                GrExpression initializer2 = tuple.getTupleInitializer();
                if (initializer2 == null) {
                    return;
                }
                if (!(initializer2 instanceof GrListOrMap)) {
                    PsiType type = initializer2.getType();
                    if (type == null) {
                        return;
                    }
                    PsiType valueType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                    this.checkAssignability(varType, valueType, tuple, variable.getNameIdentifierGroovy());
                    return;
                }
            } else if (parent instanceof GrForInClause) {
                GrExpression iterated = ((GrForInClause)parent).getIteratedExpression();
                if (iterated == null) {
                    return;
                }
                PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, parent);
                if (iteratedType == null) {
                    return;
                }
                this.checkAssignability(varType, iteratedType, iterated, variable.getNameIdentifierGroovy());
                return;
            }
            if ((initializer = variable.getInitializerGroovy()) == null) {
                return;
            }
            PsiType rType = initializer.getType();
            if (rType == null) {
                return;
            }
            if (MyVisitor.isNewInstanceInitialingByTuple(initializer)) {
                return;
            }
            if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod) {
                GrMethod method = (GrMethod)((GrParameter)variable).getDeclarationScope();
                PsiTypeParameter[] parameters = method.getTypeParameters();
                HashMap map = ContainerUtil.newHashMap();
                for (PsiTypeParameter parameter : parameters) {
                    PsiClassType[] types = parameter.getSuperTypes();
                    if (types.length == 1) {
                        map.put(parameter, PsiWildcardType.createExtends((PsiManager)variable.getManager(), (PsiType)types[0]));
                        continue;
                    }
                    map.put(parameter, PsiWildcardType.createExtends((PsiManager)variable.getManager(), (PsiType)PsiIntersectionType.createIntersection((PsiType[])types)));
                }
                PsiSubstitutor substitutor = PsiSubstitutorImpl.createSubstitutor((Map)map);
                this.checkAssignability(substitutor.substitute(varType), initializer, variable.getNameIdentifierGroovy());
                return;
            }
            this.checkAssignability(varType, initializer, variable.getNameIdentifierGroovy());
        }

        private static boolean isNewInstanceInitialingByTuple(GrExpression initializer) {
            return initializer instanceof GrListOrMap && initializer.getReference() instanceof LiteralConstructorReference && ((LiteralConstructorReference)initializer.getReference()).getConstructedClassType() != null;
        }

        @Override
        public void visitNewExpression(GrNewExpression newExpression) {
            if (newExpression.getArrayCount() > 0) {
                return;
            }
            GrCodeReferenceElement refElement = newExpression.getReferenceElement();
            if (refElement == null) {
                return;
            }
            GrNewExpressionInfo info = new GrNewExpressionInfo(newExpression);
            this.checkConstructorCall(info);
        }

        private void checkConstructorCall(ConstructorCallInfo<?> info) {
            if (MyVisitor.hasErrorElements(info.getArgumentList())) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            GroovyResolveResult constructorResolveResult = info.advancedResolve();
            PsiElement constructor = constructorResolveResult.getElement();
            if (constructor != null) {
                if (!this.checkConstructorApplicability(constructorResolveResult, info, true)) {
                    return;
                }
            } else {
                GroovyResolveResult[] results = info.multiResolve();
                if (results.length > 0) {
                    for (GroovyResolveResult result : results) {
                        PsiElement resolved = result.getElement();
                        if (!(resolved instanceof PsiMethod) || this.checkConstructorApplicability(result, info, false)) continue;
                        return;
                    }
                    this.registerError(info.getElementToHighlight(), GroovyBundle.message("constructor.call.is.ambiguous", new Object[0]));
                } else {
                    PsiElement element;
                    GroovyResolveResult[] resolveResults;
                    boolean hasNamedArgs;
                    GrExpression[] expressionArguments = info.getExpressionArguments();
                    boolean hasClosureArgs = info.getClosureArguments().length > 0;
                    boolean bl = hasNamedArgs = info.getNamedArguments().length > 0;
                    if ((hasClosureArgs || hasNamedArgs && expressionArguments.length > 0 || !hasNamedArgs && expressionArguments.length > 0 && !MyVisitor.isOnlyOneMapParam(expressionArguments)) && (resolveResults = info.multiResolveClass()).length == 1 && (element = resolveResults[0].getElement()) instanceof PsiClass) {
                        this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.apply.default.constructor", ((PsiClass)element).getName()));
                        return;
                    }
                }
            }
            this.checkNamedArgumentsType(info);
        }

        private static boolean isOnlyOneMapParam(GrExpression[] exprs) {
            if (exprs.length != 1) {
                return false;
            }
            GrExpression e = exprs[0];
            return TypesUtil.isAssignableByMethodCallConversion((PsiType)TypesUtil.createTypeByFQClassName("java.util.Map", e), e.getType(), e);
        }

        @NotNull
        private static PsiElement getExpressionPartToHighlight(@NotNull GrExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "getExpressionPartToHighlight"));
            }
            if (expr instanceof GrClosableBlock) {
                PsiElement psiElement = ((GrClosableBlock)expr).getLBrace();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "getExpressionPartToHighlight"));
                }
                return psiElement;
            }
            GrExpression grExpression = expr;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "getExpressionPartToHighlight"));
            }
            return grExpression;
        }

        @Override
        public void visitListOrMap(GrListOrMap listOrMap) {
            PsiReference reference = listOrMap.getReference();
            if (!(reference instanceof LiteralConstructorReference)) {
                return;
            }
            GroovyResolveResult[] results = ((LiteralConstructorReference)reference).multiResolve(false);
            if (results.length == 0) {
                return;
            }
            this.checkConstructorCall(new GrListOrMapInfo(listOrMap));
        }

        @Override
        public void visitThrowStatement(GrThrowStatement throwStatement) {
            GrExpression exception = throwStatement.getException();
            if (exception != null) {
                PsiElement throwWord = throwStatement.getFirstChild();
                this.checkAssignability((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord);
            }
        }

        private boolean checkConstructorApplicability(GroovyResolveResult constructorResolveResult, CallInfo<?> info, boolean checkUnknownArgs) {
            PsiType[] newTypes;
            GrExpression[] exprArgs;
            PsiElement element = constructorResolveResult.getElement();
            LOG.assertTrue(element instanceof PsiMethod && ((PsiMethod)element).isConstructor(), (Object)element);
            PsiMethod constructor = (PsiMethod)element;
            GrArgumentList argList = info.getArgumentList();
            if (argList != null && (exprArgs = argList.getExpressionArguments()).length == 0 && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
                return true;
            }
            PsiType[] types = info.getArgumentTypes();
            PsiClass containingClass = constructor.getContainingClass();
            if (types != null && containingClass != null && (newTypes = GrInnerClassConstructorUtil.addEnclosingArgIfNeeded(types, info.getCall(), containingClass)).length != types.length) {
                return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, new DelegatingCallInfo(info){

                    @Override
                    @Nullable
                    public PsiType[] getArgumentTypes() {
                        return newTypes;
                    }
                });
            }
            return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, info);
        }

        @Override
        public void visitConstructorInvocation(GrConstructorInvocation invocation) {
            GrConstructorInvocationInfo info = new GrConstructorInvocationInfo(invocation);
            this.checkConstructorCall(info);
            this.checkNamedArgumentsType(info);
        }

        @Override
        public void visitIndexProperty(GrIndexProperty expression) {
            this.checkIndexProperty(new GrIndexPropertyInfo(expression));
        }

        private void checkIndexProperty(CallInfo<? extends GrIndexProperty> info) {
            PsiType[] types;
            if (MyVisitor.hasErrorElements(info.getArgumentList())) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            PsiType type = info.getQualifierInstanceType();
            if (MyVisitor.checkSimpleArrayAccess(info, type, types = info.getArgumentTypes())) {
                return;
            }
            GroovyResolveResult[] results = info.multiResolve();
            GroovyResolveResult resolveResult = info.advancedResolve();
            if (resolveResult.getElement() != null) {
                PsiElement resolved = resolveResult.getElement();
                if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                    this.checkMethodApplicability(resolveResult, true, info);
                } else if (resolved instanceof GrField) {
                    this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), true, info);
                } else if (resolved instanceof PsiField) {
                    this.checkCallApplicability(((PsiField)resolved).getType(), true, info);
                }
            } else if (results.length > 0) {
                for (GroovyResolveResult result : results) {
                    PsiElement resolved = result.getElement();
                    if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : (resolved instanceof GrField ? !this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), false, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), false, info)))) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("method.call.is.ambiguous", new Object[0]));
            } else {
                String typesString = MyVisitor.buildArgTypesList(types);
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.find.operator.overload.method", typesString));
            }
        }

        private static boolean checkSimpleArrayAccess(CallInfo<? extends GrIndexProperty> info, PsiType type, PsiType[] types) {
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            assert (types != null);
            return PsiUtil.isLValue(info.getCall()) ? types.length == 2 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall()) && TypesUtil.isAssignable(((PsiArrayType)type).getComponentType(), types[1], info.getCall()) : types.length == 1 && TypesUtil.isAssignable((PsiType)PsiType.INT, types[0], info.getCall());
        }

        private boolean checkCannotInferArgumentTypes(CallInfo info) {
            if (info.getArgumentTypes() != null) {
                return true;
            }
            this.highlightUnknownArgs(info);
            return false;
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
            this.checkMethodCall(new GrMethodCallInfo(methodCallExpression));
        }

        @Override
        public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
            this.checkMethodCall(new GrMethodCallInfo(applicationStatement));
        }

        @Override
        public void visitBinaryExpression(GrBinaryExpression binary) {
            this.checkOperator(new GrBinaryExprInfo(binary));
        }

        @Override
        public void visitEnumConstant(GrEnumConstant enumConstant) {
            GrEnumConstantInfo info = new GrEnumConstantInfo(enumConstant);
            this.checkConstructorCall(info);
            this.checkNamedArgumentsType(info);
        }

        private void checkNamedArgumentsType(CallInfo<?> info) {
            Object rawCall = info.getCall();
            if (!(rawCall instanceof GrCall)) {
                return;
            }
            GrCall call = (GrCall)rawCall;
            GrNamedArgument[] namedArguments = PsiUtil.getFirstMapNamedArguments(call);
            if (namedArguments.length == 0) {
                return;
            }
            Map<String, NamedArgumentDescriptor> map = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
            if (map == null) {
                return;
            }
            for (GrNamedArgument namedArgument : namedArguments) {
                PsiType expressionType;
                GrExpression namedArgumentExpression;
                String labelName = namedArgument.getLabelName();
                NamedArgumentDescriptor descriptor = map.get(labelName);
                if (descriptor == null || (namedArgumentExpression = namedArgument.getExpression()) == null || MyVisitor.isNewInstanceInitialingByTuple(namedArgumentExpression) || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), call.getManager(), call.getResolveScope())) == null || descriptor.checkType(expressionType, call)) continue;
                this.registerError((PsiElement)namedArgumentExpression, "Type of argument '" + labelName + "' can not be '" + expressionType.getPresentableText() + "'");
            }
        }

        @Override
        public void visitParameterList(final GrParameterList parameterList) {
            Object[] parameters;
            PsiElement parent = parameterList.getParent();
            if (parent instanceof GrClosableBlock && (parameters = parameterList.getParameters()).length > 0) {
                List<PsiType[]> signatures = ClosureParamsEnhancer.findFittingSignatures((GrClosableBlock)parent);
                final List paramTypes = ContainerUtil.map((Object[])parameters, (Function)new Function<GrParameter, PsiType>(){

                    public PsiType fun(GrParameter parameter) {
                        return parameter.getType();
                    }
                });
                if (signatures.size() > 1) {
                    PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures, (Condition)new Condition<PsiType[]>(){

                        public boolean value(PsiType[] types) {
                            for (int i = 0; i < types.length; ++i) {
                                if (MyVisitor.typesAreEqual(types[i], (PsiType)paramTypes.get(i), parameterList)) continue;
                                return false;
                            }
                            return true;
                        }
                    });
                    if (fittingSignature == null) {
                        this.registerError((PsiElement)parameterList, GroovyInspectionBundle.message("no.applicable.signature.found", new Object[0]));
                    }
                } else if (signatures.size() == 1) {
                    PsiType[] types = signatures.get(0);
                    for (int i = 0; i < types.length; ++i) {
                        PsiType actual;
                        PsiType expected;
                        GrTypeElement typeElement = parameters[i].getTypeElementGroovy();
                        if (typeElement == null || MyVisitor.typesAreEqual(expected = types[i], actual = (PsiType)paramTypes.get(i), parameterList)) continue;
                        this.registerError((PsiElement)typeElement, GroovyInspectionBundle.message("expected.type.0", expected.getPresentableText()));
                    }
                }
            }
        }

        private static boolean typesAreEqual(@NotNull PsiType expected, @NotNull PsiType actual, @NotNull PsiElement context) {
            if (expected == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "typesAreEqual"));
            }
            if (actual == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "typesAreEqual"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "typesAreEqual"));
            }
            return TypesUtil.isAssignableByMethodCallConversion(expected, actual, context) && TypesUtil.isAssignableByMethodCallConversion(actual, expected, context);
        }

        private static boolean hasErrorElements(@Nullable PsiElement e) {
            if (e == null) {
                return false;
            }
            for (PsiElement child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiErrorElement)) continue;
                return true;
            }
            return false;
        }

        private void checkOperator(CallInfo<? extends GrBinaryExpression> info) {
            if (MyVisitor.hasErrorElements(info.getCall())) {
                return;
            }
            GroovyResolveResult[] results = info.multiResolve();
            GroovyResolveResult resolveResult = info.advancedResolve();
            if (MyVisitor.isOperatorWithSimpleTypes(info.getCall(), resolveResult)) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            if (resolveResult.getElement() != null) {
                this.checkMethodApplicability(resolveResult, true, info);
            } else if (results.length > 0) {
                for (GroovyResolveResult result : results) {
                    if (this.checkMethodApplicability(result, false, info)) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("method.call.is.ambiguous", new Object[0]));
            }
        }

        private static boolean isOperatorWithSimpleTypes(GrBinaryExpression binary, GroovyResolveResult result) {
            if (result.getElement() != null && result.isApplicable()) {
                return false;
            }
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            PsiType ltype = left.getType();
            PsiType rtype = right != null ? right.getType() : null;
            return TypesUtil.isNumericType(ltype) && (rtype == null || TypesUtil.isNumericType(rtype));
        }

        private void checkMethodCall(CallInfo<? extends GrMethodCall> info) {
            if (MyVisitor.hasErrorElements(info.getArgumentList())) {
                return;
            }
            if (info.getInvokedExpression() instanceof GrReferenceExpression) {
                GrExpression qualifier;
                GrReferenceExpression referenceExpression = (GrReferenceExpression)info.getInvokedExpression();
                GroovyResolveResult resolveResult = info.advancedResolve();
                GroovyResolveResult[] results = info.multiResolve();
                PsiElement resolved = resolveResult.getElement();
                if (resolved == null && (qualifier = referenceExpression.getQualifierExpression()) == null && GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
                    return;
                }
                if (!this.checkCannotInferArgumentTypes(info)) {
                    return;
                }
                PsiType type = referenceExpression.getType();
                if (resolved != null) {
                    if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                        this.checkMethodApplicability(resolveResult, true, info);
                    } else {
                        this.checkCallApplicability(type, true, info);
                    }
                } else if (results.length > 0) {
                    for (GroovyResolveResult result : results) {
                        PsiElement current = result.getElement();
                        if (!(current instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : !this.checkCallApplicability(type, false, info))) continue;
                        return;
                    }
                    this.registerError(info.getElementToHighlight(), GroovyBundle.message("method.call.is.ambiguous", new Object[0]));
                }
            } else if (info.getInvokedExpression() != null) {
                PsiType type = info.getInvokedExpression().getType();
                this.checkCallApplicability(type, true, info);
            }
            this.checkNamedArgumentsType(info);
        }

        private void highlightInapplicableMethodUsage(@NotNull GroovyResolveResult methodResolveResult, @NotNull CallInfo info, @NotNull PsiMethod method) {
            if (methodResolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "highlightInapplicableMethodUsage"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "highlightInapplicableMethodUsage"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "highlightInapplicableMethodUsage"));
            }
            PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
            PsiType[] argumentTypes = info.getArgumentTypes();
            if (containingClass == null) {
                this.registerCannotApplyError(method.getName(), info);
                return;
            }
            String typesString = MyVisitor.buildArgTypesList(argumentTypes);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            PsiClassType containingType = factory.createType(containingClass, methodResolveResult.getSubstitutor());
            String canonicalText = containingType.getInternalCanonicalText();
            String message = method.isConstructor() ? GroovyBundle.message("cannot.apply.constructor", method.getName(), canonicalText, typesString) : GroovyBundle.message("cannot.apply.method1", method.getName(), canonicalText, typesString);
            this.registerError(info.getElementToHighlight(), message, MyVisitor.genCastFixes(GrClosureSignatureUtil.createSignature(methodResolveResult), argumentTypes, info.getArgumentList()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }

        private static LocalQuickFix[] genCastFixes(GrSignature signature, PsiType[] argumentTypes, @Nullable GrArgumentList argumentList) {
            if (argumentList == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            List args = GroovyAssignabilityCheckInspection.getExpressionArgumentsOfCall(argumentList);
            if (args == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            List<GrClosureSignature> signatures = GrClosureSignatureUtil.generateSimpleSignatures(signature);
            ArrayList<Pair<Integer, PsiType>> allErrors = new ArrayList<Pair<Integer, PsiType>>();
            for (GrClosureSignature closureSignature : signatures) {
                GrClosureSignatureUtil.MapResultWithError<PsiType> mapResultWithError = GrClosureSignatureUtil.mapSimpleSignatureWithErrors(closureSignature, argumentTypes, Function.ID, argumentList, 1);
                if (mapResultWithError == null) continue;
                List<Pair<Integer, PsiType>> errors = mapResultWithError.getErrors();
                for (Pair<Integer, PsiType> error : errors) {
                    if ((Integer)error.first == 0 && PsiImplUtil.hasNamedArguments(argumentList)) continue;
                    allErrors.add(error);
                }
            }
            ArrayList<ParameterCastFix> fixes = new ArrayList<ParameterCastFix>();
            for (Pair pair : allErrors) {
                fixes.add(new ParameterCastFix((Integer)pair.first, (PsiType)pair.second, (GrExpression)args.get((Integer)pair.first)));
            }
            return fixes.toArray(new LocalQuickFix[fixes.size()]);
        }

        private boolean checkCallApplicability(PsiType type, boolean checkUnknownArgs, CallInfo info) {
            PsiType[] argumentTypes = info.getArgumentTypes();
            GrExpression invoked = info.getInvokedExpression();
            if (invoked == null) {
                return true;
            }
            if (type instanceof GrClosureType) {
                if (argumentTypes == null) {
                    return true;
                }
                GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(argumentTypes, (GrClosureType)type, info.getCall());
                switch (result) {
                    case inapplicable: {
                        this.registerCannotApplyError(invoked.getText(), info);
                        return false;
                    }
                    case canBeApplicable: {
                        if (checkUnknownArgs) {
                            this.highlightUnknownArgs(info);
                        }
                        return !checkUnknownArgs;
                    }
                }
                return true;
            }
            if (type != null) {
                GroovyResolveResult[] calls;
                for (GroovyResolveResult result : calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)invoked, argumentTypes)) {
                    PsiElement resolved = result.getElement();
                    if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, checkUnknownArgs, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), checkUnknownArgs && calls.length == 1, info))) continue;
                    return false;
                }
                if (calls.length == 0 && !(invoked instanceof GrString)) {
                    this.registerCannotApplyError(invoked.getText(), info);
                }
                return true;
            }
            return true;
        }

        private void registerCannotApplyError(String invokedText, CallInfo info) {
            String typesString = MyVisitor.buildArgTypesList(info.getArgumentTypes());
            this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString));
        }

        private static String buildArgTypesList(PsiType[] argTypes) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            for (int i = 0; i < argTypes.length; ++i) {
                PsiType argType;
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append((argType = argTypes[i]) != null ? argType.getInternalCanonicalText() : "?");
            }
            builder.append(")");
            return builder.toString();
        }

        private boolean checkMethodApplicability(@NotNull GroovyResolveResult methodResolveResult, boolean checkUnknownArgs, @NotNull CallInfo info) {
            PsiType type;
            GrExpression qualifierExpression;
            if (methodResolveResult == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkMethodApplicability"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "checkMethodApplicability"));
            }
            PsiElement element = methodResolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return true;
            }
            if (element instanceof GrBuilderMethod) {
                return true;
            }
            PsiMethod method = (PsiMethod)element;
            if ("call".equals(method.getName()) && info.getInvokedExpression() instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)info.getInvokedExpression()).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof GrClosureType) {
                GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), (GrClosureType)type, info.getInvokedExpression());
                switch (result) {
                    case inapplicable: {
                        this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                        return false;
                    }
                    case canBeApplicable: {
                        if (checkUnknownArgs) {
                            this.highlightUnknownArgs(info);
                        }
                        return !checkUnknownArgs;
                    }
                }
                return true;
            }
            if (method instanceof GrGdkMethod && info.getInvokedExpression() instanceof GrReferenceExpression) {
                PsiMethod staticMethod = ((GrGdkMethod)method).getStaticMethod();
                PsiType qualifierType = info.getQualifierInstanceType();
                GrReferenceExpression invoked = (GrReferenceExpression)info.getInvokedExpression();
                GrExpression qualifier = PsiImplUtil.getRuntimeQualifier(invoked);
                if (qualifierType != null && !GdkMethodUtil.isCategoryMethod(staticMethod, qualifierType, qualifier, methodResolveResult.getSubstitutor()) && !MyVisitor.checkCategoryQualifier(invoked, qualifier, staticMethod, methodResolveResult.getSubstitutor())) {
                    this.registerError(info.getHighlightElementForCategoryQualifier(), GroovyInspectionBundle.message("category.method.0.cannot.be.applied.to.1", method.getName(), qualifierType.getCanonicalText()));
                    return false;
                }
            }
            if (info.getArgumentTypes() == null) {
                return true;
            }
            GrClosureSignatureUtil.ApplicabilityResult applicable = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), method, methodResolveResult.getSubstitutor(), info.getCall(), false);
            switch (applicable) {
                case inapplicable: {
                    this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }

        private static boolean checkCategoryQualifier(GrReferenceExpression place, GrExpression qualifier, PsiMethod gdkMethod, PsiSubstitutor substitutor) {
            PsiClassType categoryType;
            PsiClass categoryAnnotationOwner = MyVisitor.inferCategoryAnnotationOwner(place, qualifier);
            if (categoryAnnotationOwner != null && (categoryType = GdkMethodUtil.getCategoryType(categoryAnnotationOwner)) != null) {
                return GdkMethodUtil.isCategoryMethod(gdkMethod, (PsiType)categoryType, qualifier, substitutor);
            }
            return false;
        }

        private static PsiClass inferCategoryAnnotationOwner(GrReferenceExpression place, GrExpression qualifier) {
            PsiElement resolved;
            if (qualifier == null) {
                GrMethod container = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class, (boolean)true, (Class[])new Class[]{GrMember.class});
                if (container != null && !container.hasModifierProperty("static")) {
                    return container.getContainingClass();
                }
            } else if (PsiUtil.isThisReference(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return (PsiClass)resolved;
            }
            return null;
        }

        private void highlightUnknownArgs(@NotNull CallInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyAssignabilityCheckInspection$MyVisitor", "highlightUnknownArgs"));
            }
            this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.infer.argument.types", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.WEAK_WARNING);
        }

        @Override
        public void visitElement(GroovyPsiElement element) {
        }
    }
}

