/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrCastFix
extends GroovyFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(GrCastFix.class);
    private PsiType myExpectedType;

    public GrCastFix(PsiType expectedType, GrExpression expression) {
        this.myExpectedType = PsiImplUtil.normalizeWildcardTypeByPosition(expectedType, expression);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        GrExpression cast = GrCastFix.findExpressionToCast(descriptor);
        if (cast == null) {
            return;
        }
        GrCastFix.doCast(project, this.myExpectedType, cast);
    }

    private static GrExpression findExpressionToCast(ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (parent instanceof GrVariable) {
            return ((GrVariable)parent).getInitializerGroovy();
        }
        if (parent instanceof GrAssignmentExpression) {
            return ((GrAssignmentExpression)parent).getRValue();
        }
        if (parent instanceof GrThrowStatement) {
            return ((GrThrowStatement)parent).getException();
        }
        if (parent instanceof GrReturnStatement) {
            return ((GrReturnStatement)parent).getReturnValue();
        }
        if (element instanceof GrExpression) {
            return (GrExpression)element;
        }
        LogMessageEx.error((Logger)LOG, (String)("can't find expression to cast at position " + element.getTextRange()), (String[])new String[]{element.getContainingFile().getText()});
        return null;
    }

    static void doCast(@NotNull Project project, @NotNull PsiType type, @NotNull GrExpression expr) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix", "doCast"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix", "doCast"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix", "doCast"));
        }
        if (!type.isValid()) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrSafeCastExpression cast = (GrSafeCastExpression)factory.createExpressionFromText("foo as String");
        GrTypeElement typeElement = factory.createTypeElement(type);
        cast.getOperand().replaceWithExpression(expr, true);
        cast.getCastTypeElement().replace(typeElement);
        GrExpression replaced = expr.replaceWithExpression(cast, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
    }

    @NotNull
    public String getName() {
        String string = "Cast to " + this.myExpectedType.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix", "getName"));
        }
        return string;
    }
}

