/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.SuppressByGroovyCommentFix;
import org.jetbrains.plugins.groovy.codeInspection.SuppressForMemberFix;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GroovySuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = GroovySuppressableInspectionTool.getSuppressActions(this.getShortName());
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public static SuppressQuickFix[] getSuppressActions(String name) {
        HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)name);
        return new SuppressQuickFix[]{new SuppressByGroovyCommentFix(displayKey), new SuppressForMemberFix(displayKey, false), new SuppressForMemberFix(displayKey, true)};
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool", "isSuppressedFor"));
        }
        return GroovySuppressableInspectionTool.isElementToolSuppressedIn(element, this.getID());
    }

    public static boolean isElementToolSuppressedIn(PsiElement place, String toolId) {
        return GroovySuppressableInspectionTool.getElementToolSuppressedIn(place, toolId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiElement getElementToolSuppressedIn(PsiElement place, String toolId) {
        if (place == null) {
            return null;
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            GrDocCommentOwner owner;
            GrStatement statement = PsiUtil.findEnclosingStatement(place);
            if (statement != null) {
                String text;
                Matcher matcher;
                PsiElement prev;
                for (prev = statement.getPrevSibling(); prev != null && StringUtil.isEmpty((String)prev.getText().trim()); prev = prev.getPrevSibling()) {
                }
                if (prev instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                    PsiElement psiElement = prev;
                    return psiElement;
                }
            }
            GrMember member = null;
            GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)place, GrDocComment.class);
            if (docComment != null && (owner = docComment.getOwner()) instanceof GrMember) {
                member = (GrMember)((Object)owner);
            }
            if (member == null) {
                member = (GrMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{GrMember.class});
            }
            while (member != null) {
                GrModifierList modifierList = member.getModifierList();
                for (String ids : GroovySuppressableInspectionTool.getInspectionIdsSuppressedInAnnotation(modifierList)) {
                    if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)toolId)) continue;
                    GrModifierList grModifierList = modifierList;
                    return grModifierList;
                }
                member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)member, GrMember.class);
            }
            PsiElement psiElement = null;
            return psiElement;
        }
        finally {
            accessToken.finish();
        }
    }

    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(GrModifierList modifierList) {
        if (modifierList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool", "getInspectionIdsSuppressedInAnnotation"));
            }
            return list;
        }
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        if (annotation == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool", "getInspectionIdsSuppressedInAnnotation"));
            }
            return list;
        }
        GrAnnotationMemberValue attributeValue = (GrAnnotationMemberValue)annotation.findAttributeValue(null);
        ArrayList<String> result = new ArrayList<String>();
        if (attributeValue instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue annotationMemberValue : ((GrAnnotationArrayInitializer)attributeValue).getInitializers()) {
                String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(annotationMemberValue);
                if (id == null) continue;
                result.add(id);
            }
        } else {
            String id = GroovySuppressableInspectionTool.getInspectionIdSuppressedInAnnotationAttribute(attributeValue);
            if (id != null) {
                result.add(id);
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovySuppressableInspectionTool", "getInspectionIdsSuppressedInAnnotation"));
        }
        return arrayList;
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(GrAnnotationMemberValue element) {
        Object value;
        if (element instanceof GrLiteral && (value = ((GrLiteral)element).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }
}

