/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class GroovyFix
implements LocalQuickFix {
    public static final GroovyFix[] EMPTY_ARRAY = new GroovyFix[0];

    @NotNull
    public String getFamilyName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "getFamilyName"));
        }
        return "";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/GroovyFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (GroovyFix.isQuickFixOnReadOnlyFile(problemElement)) {
            return;
        }
        try {
            this.doFix(project, descriptor);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2) throws IncorrectOperationException;

    protected static boolean isQuickFixOnReadOnlyFile(PsiElement problemElement) {
        PsiFile containingPsiFile = problemElement.getContainingFile();
        if (containingPsiFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingPsiFile.getVirtualFile();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)problemElement.getProject());
        Project project = facade.getProject();
        ReadonlyStatusHandler handler = ReadonlyStatusHandler.getInstance((Project)project);
        ReadonlyStatusHandler.OperationStatus status = handler.ensureFilesWritable(new VirtualFile[]{virtualFile});
        return status.hasReadonlyFiles();
    }

    protected static void replaceExpression(GrExpression expression, String newExpression) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expression.getProject());
        GrExpression newCall = factory.createExpressionFromText(newExpression);
        expression.replaceWithExpression(newCall, true);
    }

    protected static void replaceStatement(GrStatement statement, String newStatement) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        GrStatement newCall = (GrStatement)factory.createTopElementFromText(newStatement);
        statement.replaceWithStatement(newCall);
    }

    protected static void replaceStatement(GrStatement oldStatement, GrStatement newStatement) throws IncorrectOperationException {
        if (newStatement instanceof GrBlockStatement) {
            GrBlockStatement blockStatement = (GrBlockStatement)newStatement;
            GrOpenBlock openBlock = blockStatement.getBlock();
            GrStatement[] statements = openBlock.getStatements();
            if (statements.length == 0) {
                oldStatement.removeStatement();
            } else {
                PsiElement parent = oldStatement.getParent();
                if (parent instanceof GrStatementOwner) {
                    GrStatementOwner statementOwner = (GrStatementOwner)parent;
                    for (GrStatement statement : statements) {
                        statementOwner.addStatementBefore(statement, oldStatement);
                    }
                    oldStatement.removeStatement();
                } else if (parent instanceof GrControlStatement) {
                    oldStatement.replace(newStatement);
                }
            }
        } else {
            oldStatement.replaceWithStatement(newStatement);
        }
    }
}

