/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrInspectionUtil {
    public static boolean isNull(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isNull"));
        }
        return "null".equals(expression.getText());
    }

    public static boolean isEquality(@NotNull GrBinaryExpression binaryCondition) {
        if (binaryCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isEquality"));
        }
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mEQUAL == tokenType;
    }

    public static boolean isInequality(@NotNull GrBinaryExpression binaryCondition) {
        if (binaryCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/GrInspectionUtil", "isInequality"));
        }
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mNOT_EQUAL == tokenType;
    }
}

