/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public abstract class BaseInspection
extends GroovySuppressableInspectionTool {
    private final String m_shortName = StringUtil.trimEnd((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Inspection");
    public static final String ASSIGNMENT_ISSUES = "Assignment issues";
    public static final String CONFUSING_CODE_CONSTRUCTS = "Potentially confusing code constructs";
    public static final String CONTROL_FLOW = "Control Flow";
    public static final String PROBABLE_BUGS = "Probable bugs";
    public static final String ERROR_HANDLING = "Error handling";
    public static final String GPATH = "GPath inspections";
    public static final String METHOD_METRICS = "Method Metrics";
    public static final String THREADING_ISSUES = "Threading issues";
    public static final String VALIDITY_ISSUES = "Validity issues";
    public static final String ANNOTATIONS_ISSUES = "Annotations verifying";

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @NotNull
    public String getShortName() {
        String string = this.m_shortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    protected BaseInspectionVisitor buildGroovyVisitor(@NotNull ProblemsHolder problemsHolder, boolean onTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "buildGroovyVisitor"));
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(problemsHolder);
        visitor.setOnTheFly(onTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "buildGroovyVisitor"));
        }
        return baseInspectionVisitor;
    }

    @Nullable
    protected String buildErrorString(Object ... args) {
        return null;
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "buildFix"));
        }
        return null;
    }

    @Nullable
    protected GroovyFix[] buildFixes(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "buildFixes"));
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager inspectionManager, boolean isOnTheFly) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "checkFile"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/BaseInspection", "checkFile"));
        }
        if (!(psiFile instanceof GroovyFileBase)) {
            return super.checkFile(psiFile, inspectionManager, isOnTheFly);
        }
        GroovyFileBase groovyFile = (GroovyFileBase)psiFile;
        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, psiFile, isOnTheFly);
        BaseInspectionVisitor visitor = this.buildGroovyVisitor(problemsHolder, isOnTheFly);
        groovyFile.accept(visitor);
        return problemsHolder.getResultsArray();
    }

    @NotNull
    protected abstract BaseInspectionVisitor buildVisitor();
}

