/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.JavaLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInsight.GroovyMarkerTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableDeclarationImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GroovyLineMarkerProvider
extends JavaLineMarkerProvider {
    public GroovyLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        super(daemonSettings, colorsManager);
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInsight/GroovyLineMarkerProvider", "getLineMarkerInfo"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiNameIdentifierOwner) {
            ASTNode node;
            if (parent instanceof GrField && element == ((GrField)parent).getNameIdentifierGroovy()) {
                for (GrAccessorMethod method : GroovyPropertyUtils.getFieldAccessors((GrField)parent)) {
                    MethodSignatureBackedByPsiMethod superSignature = null;
                    try {
                        superSignature = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
                    }
                    catch (IndexNotReadyException e) {
                        // empty catch block
                    }
                    if (superSignature == null) continue;
                    boolean overrides = method.hasModifierProperty("abstract") == superSignature.getMethod().hasModifierProperty("abstract");
                    Icon icon = overrides ? AllIcons.Gutter.OverridingMethod : AllIcons.Gutter.ImplementingMethod;
                    MarkerType type = GroovyMarkerTypes.OVERRIDING_PROPERTY_TYPE;
                    return new LineMarkerInfo(element, element.getTextRange(), icon, 4, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
                }
            } else if (parent instanceof GrMethod && element == ((GrMethod)parent).getNameIdentifierGroovy() && ((GrMethod)parent).getReflectedMethods().length > 0 && GroovyLineMarkerProvider.hasSuperMethods((GrMethod)element.getParent())) {
                Icon icon = AllIcons.Gutter.OverridingMethod;
                MarkerType type = GroovyMarkerTypes.OVERRIDING_METHOD;
                return new LineMarkerInfo(element, element.getTextRange(), icon, 4, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
            }
            if ((node = element.getNode()) != null && TokenSets.PROPERTY_NAMES.contains(node.getElementType())) {
                return super.getLineMarkerInfo(((PsiNameIdentifierOwner)parent).getNameIdentifier());
            }
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS && element.getFirstChild() == null) {
            PsiElement element1 = element;
            boolean isMember = false;
            while (element1 != null && !(element1 instanceof PsiFile) && element1.getPrevSibling() == null) {
                if (!((element1 = element1.getParent()) instanceof PsiMember) && !(element1 instanceof GrVariableDeclarationImpl)) continue;
                isMember = true;
                break;
            }
            if (isMember && !(element1 instanceof PsiAnonymousClass) && !(element1.getParent() instanceof PsiAnonymousClass)) {
                PsiFile file = element1.getContainingFile();
                Document document = file == null ? null : PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                boolean drawSeparator = false;
                if (document != null) {
                    CharSequence documentChars = document.getCharsSequence();
                    int category = GroovyLineMarkerProvider.getGroovyCategory(element1, documentChars);
                    for (PsiElement child = element1.getPrevSibling(); child != null; child = child.getPrevSibling()) {
                        int category1 = GroovyLineMarkerProvider.getGroovyCategory(child, documentChars);
                        if (category1 == 0) continue;
                        drawSeparator = category != 1 || category1 != 1;
                        break;
                    }
                }
                if (drawSeparator) {
                    GrDocComment comment = null;
                    if (element1 instanceof GrDocCommentOwner) {
                        comment = ((GrDocCommentOwner)element1).getDocComment();
                    }
                    LineMarkerInfo info = new LineMarkerInfo(element, comment != null ? comment.getTextRange() : element.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
                    EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
                    info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                    info.separatorPlacement = SeparatorPlacement.TOP;
                    return info;
                }
            }
        }
        return super.getLineMarkerInfo(element);
    }

    private static boolean hasSuperMethods(GrMethod method) {
        GrReflectedMethod[] reflectedMethods;
        for (GrReflectedMethod reflectedMethod : reflectedMethods = method.getReflectedMethods()) {
            MethodSignatureBackedByPsiMethod first = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)reflectedMethod, null, (boolean)true, (boolean)false).findFirst();
            if (first == null) continue;
            return true;
        }
        return false;
    }

    private static int getGroovyCategory(PsiElement element, CharSequence documentChars) {
        GrVariable[] variables;
        if (element instanceof GrVariableDeclarationImpl && (variables = ((GrVariableDeclarationImpl)element).getVariables()).length == 1 && variables[0] instanceof GrField && variables[0].getInitializerGroovy() instanceof GrClosableBlock) {
            return 2;
        }
        return JavaLineMarkerProvider.getCategory((PsiElement)element, (CharSequence)documentChars);
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInsight/GroovyLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInsight/GroovyLineMarkerProvider", "collectSlowLineMarkers"));
        }
        HashSet methods = new HashSet();
        for (PsiElement element : elements) {
            ProgressManager.checkCanceled();
            if (element instanceof GrField) {
                methods.addAll(GroovyPropertyUtils.getFieldAccessors((GrField)element));
                continue;
            }
            if (!(element instanceof GrMethod)) continue;
            Collections.addAll(methods, ((GrMethod)element).getReflectedMethods());
        }
        GroovyLineMarkerProvider.collectOverridingMethods((Set<PsiMethod>)methods, result);
        super.collectSlowLineMarkers(elements, result);
    }

    private static void collectOverridingMethods(final Set<PsiMethod> methods, Collection<LineMarkerInfo> result) {
        HashSet overridden = new HashSet();
        THashSet classes = new THashSet();
        for (PsiMethod method : methods) {
            ProgressManager.checkCanceled();
            PsiClass parentClass = method.getContainingClass();
            if (parentClass == null || "java.lang.Object".equals(parentClass.getQualifiedName())) continue;
            classes.add(parentClass);
        }
        for (PsiClass aClass : classes) {
            try {
                AllOverridingMethodsSearch.search((PsiClass)aClass).forEach((Processor)new Processor<Pair<PsiMethod, PsiMethod>>((Set)overridden){
                    final /* synthetic */ Set val$overridden;
                    {
                        this.val$overridden = set2;
                    }

                    public boolean process(Pair<PsiMethod, PsiMethod> pair) {
                        ProgressManager.checkCanceled();
                        PsiMethod superMethod = (PsiMethod)pair.getFirst();
                        if (GroovyLineMarkerProvider.isCorrectTarget(superMethod) && GroovyLineMarkerProvider.isCorrectTarget((PsiMethod)pair.getSecond()) && methods.remove(superMethod)) {
                            if (superMethod instanceof PsiMirrorElement) {
                                // empty if block
                            }
                            this.val$overridden.add(PsiImplUtil.handleMirror((PsiElement)superMethod));
                        }
                        return !methods.isEmpty();
                    }
                });
            }
            catch (IndexNotReadyException ignored) {}
        }
        for (PsiElement element : overridden) {
            Icon icon = AllIcons.Gutter.OverridenMethod;
            PsiElement range = (element = PsiImplUtil.handleMirror((PsiElement)element)) instanceof GrNamedElement ? ((GrNamedElement)element).getNameIdentifierGroovy() : element;
            MarkerType type = element instanceof GrField ? GroovyMarkerTypes.OVERRIDEN_PROPERTY_TYPE : GroovyMarkerTypes.OVERRIDEN_METHOD;
            LineMarkerInfo info = new LineMarkerInfo(range, range.getTextRange(), icon, 6, type.getTooltip(), type.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            result.add(info);
        }
    }

    private static boolean isCorrectTarget(PsiMethod superMethod) {
        PsiElement navigationElement = superMethod.getNavigationElement();
        return superMethod.isPhysical() || navigationElement.isPhysical() && !(navigationElement instanceof PsiClass);
    }
}

