/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;

public class ReplaceDelimiterFix
extends Intention {
    @Override
    @NotNull
    public String getText() {
        if ("Replace ':' with 'in'" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix", "getText"));
        }
        return "Replace ':' with 'in'";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Replace for-each operator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix", "getFamilyName"));
        }
        return "Replace for-each operator";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix", "isAvailable"));
        }
        return true;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix", "processIntention"));
        }
        PsiFile file = element.getContainingFile();
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrForStatement forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)at, GrForStatement.class);
        if (forStatement == null) {
            return;
        }
        GrForClause clause = forStatement.getClause();
        if (clause instanceof GrForInClause) {
            GroovyFile f = GroovyPsiElementFactory.getInstance(project).createGroovyFile("in", false, null);
            PsiElement child = f.getFirstChild().getFirstChild();
            PsiElement delimiter = ((GrForInClause)clause).getDelimiter();
            delimiter.replace(child);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return true;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

