/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class GroovyCreateFieldFromUsageHelper
extends CreateFieldFromUsageHelper {
    public Template setupTemplateImpl(PsiField f, Object expectedTypes, PsiClass targetClass, Editor editor, PsiElement context, boolean createConstantField, PsiSubstitutor substitutor) {
        GrVariableDeclaration fieldDecl = (GrVariableDeclaration)f.getParent();
        GrField field = (GrField)fieldDecl.getVariables()[0];
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)fieldDecl);
        Project project = context.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        if (expectedTypes instanceof TypeConstraint[]) {
            GrTypeElement typeElement = fieldDecl.getTypeElementGroovy();
            assert (typeElement != null);
            ChooseTypeExpression expr = new ChooseTypeExpression((TypeConstraint[])expectedTypes, PsiManager.getInstance((Project)project), typeElement.getResolveScope());
            builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        } else if (expectedTypes instanceof ExpectedTypeInfo[]) {
            new GuessTypeParameters((JVMElementFactory)factory).setupTypeElement(field.getTypeElement(), (ExpectedTypeInfo[])expectedTypes, substitutor, (TemplateBuilder)builder, context, targetClass);
        }
        if (createConstantField) {
            field.setInitializerGroovy(factory.createExpressionFromText("0", null));
            builder.replaceElement((PsiElement)field.getInitializerGroovy(), (Expression)new EmptyExpression());
        }
        fieldDecl = (GrVariableDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)fieldDecl);
        Template template = builder.buildTemplate();
        TextRange range = fieldDecl.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        if (expectedTypes instanceof ExpectedTypeInfo[] && ((ExpectedTypeInfo[])expectedTypes).length > 1) {
            template.setToShortenLongNames(false);
        }
        return template;
    }

    public PsiField insertFieldImpl(@NotNull PsiClass targetClass, @NotNull PsiField field, @NotNull PsiElement place) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/annotator/intentions/GroovyCreateFieldFromUsageHelper", "insertFieldImpl"));
        }
        if (targetClass instanceof GroovyScriptClass) {
            PsiElement added = targetClass.getContainingFile().add(field.getParent());
            return (PsiField)((GrVariableDeclaration)added).getVariables()[0];
        }
        return (PsiField)targetClass.add((PsiElement)field);
    }
}

