/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.StaticChecker;

public class CreateFieldFromUsageFix
extends GrCreateFromUsageBaseFix {
    public CreateFieldFromUsageFix(GrReferenceExpression refExpression) {
        super(refExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private String getFieldName() {
        return this.getRefExpr().getReferenceName();
    }

    private String[] generateModifiers(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "generateModifiers"));
        }
        GrReferenceExpression myRefExpression = this.getRefExpr();
        if (myRefExpression != null && StaticChecker.isInStaticContext(myRefExpression, targetClass)) {
            return new String[]{"static"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.field.from.usage", this.getFieldName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "getText"));
        }
        return string;
    }

    @Override
    protected void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "invokeImpl"));
        }
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        fix.doFix(targetClass.getProject(), this.generateModifiers(targetClass), this.getFieldName(), this.calculateTypeConstrains(), this.getRefExpr());
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return super.canBeTargetClass(psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }
}

