/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GroovySingletonAnnotationInspection
extends BaseInspection {
    public static final String SINGLETON = "groovy.lang.Singleton";

    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Annotations verifying" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/inspections/GroovySingletonAnnotationInspection", "getGroupDisplayName"));
        }
        return "Annotations verifying";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check '@Singleton' annotation conventions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/inspections/GroovySingletonAnnotationInspection", "getDisplayName"));
        }
        return "Check '@Singleton' annotation conventions";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("singleton.class.should.have.private.constructor", new Object[0]);
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAnnotation(GrAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiElement parent = annotation.getParent().getParent();
            if (parent == null || !(parent instanceof GrTypeDefinition)) {
                return;
            }
            if (GroovySingletonAnnotationInspection.SINGLETON.equals(annotation.getQualifiedName())) {
                PsiMethod[] methods;
                GrTypeDefinition typeDefinition = (GrTypeDefinition)parent;
                for (PsiMethod method : methods = typeDefinition.getMethods()) {
                    PsiModifierList modifierList;
                    if (!method.isConstructor() || !(modifierList = method.getModifierList()).hasModifierProperty("public")) continue;
                    this.registerClassError(typeDefinition, new Object[0]);
                }
            }
        }
    }
}

