/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;

public class GroovyFileTypeLoader
extends FileTypeFactory {
    public static final List<FileType> GROOVY_FILE_TYPES = new ArrayList<FileType>();

    public static FileType[] getGroovyEnabledFileTypes() {
        return GROOVY_FILE_TYPES.toArray(new FileType[GROOVY_FILE_TYPES.size()]);
    }

    public static Set<String> getCustomGroovyScriptExtensions() {
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        strings.add("gdsl");
        strings.add("gpp");
        strings.add("grunit");
        for (GroovyScriptTypeDetector ep : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            Collections.addAll(strings, ep.getExtensions());
        }
        return strings;
    }

    public static List<String> getAllGroovyExtensions() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("groovy");
        strings.addAll(GroovyFileTypeLoader.getCustomGroovyScriptExtensions());
        return strings;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/GroovyFileTypeLoader", "createFileTypes"));
        }
        consumer.consume((FileType)GroovyFileType.GROOVY_FILE_TYPE, StringUtil.join(GroovyFileTypeLoader.getAllGroovyExtensions(), (String)";"));
        GROOVY_FILE_TYPES.add((FileType)GroovyFileType.GROOVY_FILE_TYPE);
    }
}

