/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector;
import org.intellij.plugins.intelliLang.inject.groovy.GrInjectionUtil;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GrConcatenationAwareInjector
implements ConcatenationAwareInjector {
    private final LanguageInjectionSupport mySupport;
    private final Configuration myConfiguration;

    public GrConcatenationAwareInjector(Configuration configuration, Project project, TemporaryPlacesRegistry temporaryPlacesRegistry) {
        this.myConfiguration = configuration;
        this.mySupport = InjectorUtils.findNotNullInjectionSupport((String)"groovy");
    }

    public void getLanguagesToInject(final @NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/groovy/GrConcatenationAwareInjector", "getLanguagesToInject"));
        }
        if (operands == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/intelliLang/inject/groovy/GrConcatenationAwareInjector", "getLanguagesToInject"));
        }
        if (operands.length == 0) {
            return;
        }
        final PsiFile file = operands[0].getContainingFile();
        if (!(file instanceof GroovyFileBase)) {
            return;
        }
        new InjectionProcessor(this.myConfiguration, this.mySupport, operands){

            @Override
            protected void processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean settingsAvailable, boolean unparsable) {
                InjectorUtils.registerInjection((Language)language, list, (PsiFile)file, (MultiHostRegistrar)registrar);
                InjectorUtils.registerSupport((LanguageInjectionSupport)GrConcatenationAwareInjector.this.mySupport, (boolean)settingsAvailable, (MultiHostRegistrar)registrar);
                InjectorUtils.putInjectedFileUserData((MultiHostRegistrar)registrar, (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)unparsable);
            }
        }.processInjections();
    }

    private static String getStringPresentation(PsiElement operand) {
        if (operand instanceof GrStringInjection) {
            return operand.getText();
        }
        return "missingValue";
    }

    @Nullable
    private String findLanguage(PsiElement[] operands) {
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])operands);
        BaseInjection params = GrConcatenationInjector.findLanguageParams(parent, this.myConfiguration);
        if (params != null) {
            return params.getInjectedLanguageId();
        }
        return null;
    }

    static class InjectionProcessor {
        private final Configuration myConfiguration;
        private final LanguageInjectionSupport mySupport;
        private final PsiElement[] myOperands;
        private boolean myShouldStop;
        private boolean myUnparsable;

        public InjectionProcessor(Configuration configuration, LanguageInjectionSupport support, PsiElement ... operands) {
            this.myConfiguration = configuration;
            this.mySupport = support;
            this.myOperands = operands;
        }

        void processInjections() {
            PsiElement firstOperand = this.myOperands[0];
            GrControlFlowOwner topBlock = ControlFlowUtils.findControlFlowOwner(firstOperand);
            final LocalSearchScope searchScope = new LocalSearchScope(new PsiElement[]{topBlock instanceof GrCodeBlock ? topBlock : firstOperand.getContainingFile()}, "", true);
            final THashSet visitedVars = new THashSet();
            final LinkedList<PsiElement> places = new LinkedList<PsiElement>();
            places.add(firstOperand);
            GrInjectionUtil.AnnotatedElementVisitor visitor = new GrInjectionUtil.AnnotatedElementVisitor(){

                @Override
                public boolean visitMethodParameter(GrExpression expression, GrCall methodCall) {
                    GroovyResolveResult result;
                    PsiElement element;
                    String methodName;
                    GrArgumentList list = methodCall.getArgumentList();
                    assert (list != null);
                    if (methodCall instanceof GrMethodCall) {
                        String referenceName;
                        GrExpression invoked = ((GrMethodCall)methodCall).getInvokedExpression();
                        String string = referenceName = invoked instanceof GrReferenceExpression ? ((GrReferenceExpression)invoked).getReferenceName() : null;
                        if ("super".equals(referenceName) || "this".equals(referenceName)) {
                            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class, (boolean)true);
                            PsiClass psiTargetClass = "super".equals(referenceName) ? (psiClass == null ? null : psiClass.getSuperClass()) : psiClass;
                            methodName = psiTargetClass == null ? null : psiTargetClass.getName();
                        } else {
                            methodName = referenceName;
                        }
                    } else {
                        GrCodeReferenceElement classRef;
                        methodName = methodCall instanceof GrNewExpression ? ((classRef = ((GrNewExpression)methodCall).getReferenceElement()) == null ? null : classRef.getReferenceName()) : null;
                    }
                    if (methodName != null && InjectionProcessor.this.areThereInjectionsWithName(methodName, false) && (element = (result = methodCall.advancedResolve()).getElement()) instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)element;
                        PsiParameter[] parameters = method.getParameterList().getParameters();
                        int index = GrInjectionUtil.findParameterIndex(expression, methodCall);
                        if (index >= 0) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[index], method, index);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitMethodReturnStatement(GrReturnStatement parent, PsiMethod method) {
                    if (InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)method, method, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitVariable(PsiVariable variable) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() != Configuration.DfaOption.OFF && visitedVars.add((Object)variable)) {
                        ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference psiReference) {
                                PsiElement element = psiReference.getElement();
                                if (element instanceof GrExpression) {
                                    GrExpression refExpression = (GrExpression)element;
                                    places.add(refExpression);
                                    if (!InjectionProcessor.this.myUnparsable) {
                                        InjectionProcessor.this.myUnparsable = InjectionProcessor.this.checkUnparsableReference(refExpression);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    if (!InjectionProcessor.this.processCommentInjections(variable)) {
                        InjectionProcessor.this.myShouldStop = true;
                    } else if (InjectionProcessor.this.areThereInjectionsWithName(variable.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)variable, null, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitAnnotationParameter(GrAnnotationNameValuePair nameValuePair, PsiAnnotation psiAnnotation) {
                    String methodName;
                    String paramName = nameValuePair.getName();
                    String string = methodName = paramName != null ? paramName : "value";
                    if (InjectionProcessor.this.areThereInjectionsWithName(methodName, false)) {
                        PsiElement element;
                        PsiReference reference = nameValuePair.getReference();
                        PsiElement psiElement = element = reference == null ? null : reference.resolve();
                        if (element instanceof PsiMethod) {
                            InjectionProcessor.this.process((PsiModifierListOwner)((PsiMethod)element), (PsiMethod)element, -1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitReference(GrReferenceExpression expression) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() == Configuration.DfaOption.OFF) {
                        return true;
                    }
                    PsiElement e = expression.resolve();
                    if (e instanceof PsiVariable) {
                        if (e instanceof PsiParameter) {
                            PsiParameterList parameterList;
                            PsiParameter p = (PsiParameter)e;
                            PsiElement declarationScope = p.getDeclarationScope();
                            PsiMethod method = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
                            PsiParameterList psiParameterList = parameterList = method == null ? null : method.getParameterList();
                            if (parameterList != null && parameterList == e.getParent() && InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                                int parameterIndex = parameterList.getParameterIndex((PsiParameter)e);
                                InjectionProcessor.this.process((PsiModifierListOwner)e, method, parameterIndex);
                            }
                        }
                        this.visitVariable((PsiVariable)e);
                    }
                    return !InjectionProcessor.this.myShouldStop;
                }
            };
            while (!places.isEmpty() && !this.myShouldStop) {
                PsiElement curPlace = (PsiElement)places.removeFirst();
                GrInjectionUtil.visitAnnotatedElements(curPlace, visitor);
            }
        }

        private void process(PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            if (!this.processAnnotationInjections(owner)) {
                this.myShouldStop = true;
            }
            for (BaseInjection injection : this.myConfiguration.getInjections("java")) {
                if (!injection.acceptsPsiElement((PsiElement)owner) || this.processXmlInjections(injection, owner, method, paramIndex)) continue;
                this.myShouldStop = true;
                break;
            }
        }

        private boolean processAnnotationInjections(PsiModifierListOwner annoElement) {
            PsiElement scope;
            String checkName = annoElement instanceof PsiParameter ? ((scope = ((PsiParameter)annoElement).getDeclarationScope()) instanceof PsiMethod ? ((PsiNamedElement)scope).getName() : ((PsiNamedElement)annoElement).getName()) : (annoElement instanceof PsiNamedElement ? ((PsiNamedElement)annoElement).getName() : null);
            if (checkName == null || !this.areThereInjectionsWithName(checkName, true)) {
                return true;
            }
            PsiAnnotation[] annotations = GrConcatenationInjector.getAnnotationFrom(annoElement, (Pair<String, ? extends Set<String>>)this.myConfiguration.getAdvancedConfiguration().getLanguageAnnotationPair(), true, true);
            if (annotations.length > 0) {
                return this.processAnnotationInjectionInner(annoElement, annotations);
            }
            return true;
        }

        private boolean checkUnparsableReference(GrExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent;
                IElementType operation = assignmentExpression.getOperationTokenType();
                if (assignmentExpression.getLValue() == expression && operation == GroovyTokenTypes.mPLUS_ASSIGN) {
                    return true;
                }
            } else if (parent instanceof GrBinaryExpression) {
                return true;
            }
            return false;
        }

        protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
            return true;
        }

        protected boolean processCommentInjectionInner(PsiVariable owner, PsiElement comment, BaseInjection injection) {
            this.processInjectionWithContext(injection, false);
            return false;
        }

        protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annotations) {
            String id = AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"value");
            String prefix = AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"prefix");
            String suffix = AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"suffix");
            BaseInjection injection = new BaseInjection("java");
            if (prefix != null) {
                injection.setPrefix(prefix);
            }
            if (suffix != null) {
                injection.setSuffix(suffix);
            }
            if (id != null) {
                injection.setInjectedLanguageId(id);
            }
            this.processInjectionWithContext(injection, false);
            return false;
        }

        protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            this.processInjectionWithContext(injection, true);
            return !injection.isTerminal();
        }

        private boolean processCommentInjections(PsiVariable owner) {
            PsiVariable anchor;
            Ref causeRef = Ref.create();
            Object object = owner.getFirstChild() instanceof PsiComment ? (owner.getModifierList() != null ? owner.getModifierList() : owner.getTypeElement()) : (anchor = owner);
            if (anchor == null) {
                return true;
            }
            BaseInjection injection = this.mySupport.findCommentInjection((PsiElement)anchor, causeRef);
            return injection == null || this.processCommentInjectionInner(owner, (PsiElement)causeRef.get(), injection);
        }

        private void processInjectionWithContext(BaseInjection injection, boolean settingsAvailable) {
            Language language = InjectedLanguage.findLanguageById((String)injection.getInjectedLanguageId());
            if (language == null) {
                ReferenceInjector injector = ReferenceInjector.findById((String)injection.getInjectedLanguageId());
                if (injector != null) {
                    language = injector.toLanguage();
                } else {
                    return;
                }
            }
            String languageID = language.getID();
            ArrayList list = ContainerUtil.newArrayList();
            boolean unparsable = false;
            String prefix = "";
            for (int i = 0; i < this.myOperands.length; ++i) {
                PsiElement operand = this.myOperands[i];
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)operand);
                if (manipulator == null) {
                    unparsable = true;
                    prefix = prefix + GrConcatenationAwareInjector.getStringPresentation(operand);
                    if (i != this.myOperands.length - 1) continue;
                    Trinity last = (Trinity)ContainerUtil.getLastItem((List)list);
                    assert (last != null);
                    InjectedLanguage injected = (InjectedLanguage)last.second;
                    list.set(list.size() - 1, Trinity.create((Object)last.first, (Object)InjectedLanguage.create((String)injected.getID(), (String)injected.getPrefix(), (String)prefix, (boolean)false), (Object)last.third));
                    continue;
                }
                InjectedLanguage injectedLanguage = InjectedLanguage.create((String)languageID, (String)prefix, (String)"", (boolean)false);
                TextRange range = manipulator.getRangeInElement(operand);
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)operand;
                list.add(Trinity.create((Object)host, (Object)injectedLanguage, (Object)range));
                prefix = "";
            }
            if (!list.isEmpty()) {
                this.processInjection(language, list, settingsAvailable, unparsable);
            }
        }

        protected void processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean settingsAvailable, boolean unparsable) {
        }
    }
}

