/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgErrorUtil {
    public static final String SETTINGS_LINK = "settings";
    public static final String MAPPING_ERROR_MESSAGE = String.format("Please, ensure that your project base dir is hg root directory or specify full repository path in  <a href='settings'>directory mappings panel</a>.", new Object[0]);

    private HgErrorUtil() {
    }

    public static boolean isAbort(@Nullable HgCommandResult result) {
        if (result == null) {
            return true;
        }
        List<String> errorLines = result.getErrorLines();
        for (String line : errorLines) {
            if (StringUtil.isEmptyOrSpaces((String)line) || !line.trim().startsWith("abort:")) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuthorizationError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String line = HgErrorUtil.getLastErrorLine(result);
        return !StringUtil.isEmptyOrSpaces((String)line) && (line.contains("authorization required") || line.contains("authorization failed"));
    }

    @Nullable
    private static String getLastErrorLine(@Nullable HgCommandResult result) {
        if (result == null) {
            return null;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return null;
        }
        return errorLines.get(errorLines.size() - 1);
    }

    public static boolean hasErrorsInCommandExecution(@Nullable HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() != 0;
    }

    public static boolean hasAuthorizationInDestinationPath(@Nullable String destinationPath) {
        if (StringUtil.isEmptyOrSpaces((String)destinationPath)) {
            return false;
        }
        return HgUtil.URL_WITH_PASSWORD.matcher(destinationPath).matches();
    }

    @NotNull
    public static NotificationListener getMappingErrorNotificationListener(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgErrorUtil", "getMappingErrorNotificationListener"));
        }
        NotificationListener.Adapter adapter = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgErrorUtil$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgErrorUtil$1", "hyperlinkActivated"));
                }
                if (HgErrorUtil.SETTINGS_LINK.equals(e.getDescription())) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]));
                }
            }
        };
        if (adapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgErrorUtil", "getMappingErrorNotificationListener"));
        }
        return adapter;
    }

    public static boolean isUnknownEncodingError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return false;
        }
        String line = errorLines.get(0);
        return !StringUtil.isEmptyOrSpaces((String)line) && line.contains("abort") && line.contains("unknown encoding");
    }
}

