/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HgBookmarkDialog
extends DialogWrapper {
    @NotNull
    private JBTextField myBookmarkName;
    @NotNull
    private JBCheckBox myActiveCheckbox;

    public HgBookmarkDialog(@Nullable Project project) {
        super(project, false);
        this.setTitle("Create Bookmark");
        this.setResizable(false);
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.mercurial.create.bookmark";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myBookmarkName;
        if (jBTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgBookmarkDialog", "getPreferredFocusedComponent"));
        }
        return jBTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = HgBookmarkDialog.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgBookmarkDialog", "getDimensionServiceKey"));
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultAnchor(21).setDefaultFill(2);
        JLabel icon = new JLabel(UIUtil.getQuestionIcon(), 2);
        this.myBookmarkName = new JBTextField(13);
        JBLabel bookmarkLabel = new JBLabel("Bookmark name:");
        bookmarkLabel.setLabelFor((Component)this.myBookmarkName);
        this.myActiveCheckbox = new JBCheckBox("Inactive", false);
        contentPanel.add((Component)icon, g.nextLine().next().coverColumn(3).pady(10));
        contentPanel.add((Component)bookmarkLabel, g.next().fillCellNone().insets(new Insets(0, 6, 4, 10)));
        contentPanel.add((Component)this.myBookmarkName, g.next().coverLine().setDefaultWeightX(1.0));
        contentPanel.add((Component)this.myActiveCheckbox, g.nextLine().next().next().coverLine(2));
        JPanel jPanel = contentPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgBookmarkDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    public boolean isActive() {
        return !this.myActiveCheckbox.isSelected();
    }

    @Nullable
    public String getName() {
        return this.myBookmarkName.getText();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String message = "You have to specify bookmark name.";
        if (StringUtil.isEmptyOrSpaces((String)this.getName())) {
            return new ValidationInfo(message, (JComponent)this.myBookmarkName);
        }
        return null;
    }
}

