/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.provider.update.HgRegularUpdater;
import org.zmlx.hg4idea.provider.update.HgUpdateConfigurationSettings;
import org.zmlx.hg4idea.ui.HgUpdateDialog;

public class HgUpdateEnvironment
implements UpdateEnvironment {
    private final Project project;
    private final HgUpdateConfigurationSettings updateConfiguration;

    public HgUpdateEnvironment(Project project) {
        this.project = project;
        this.updateConfiguration = (HgUpdateConfigurationSettings)ServiceManager.getService((Project)project, HgUpdateConfigurationSettings.class);
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator indicator, @NotNull Ref<SequentialUpdatesContext> context) {
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment", "updateDirectories"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment", "updateDirectories"));
        }
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        boolean result = true;
        for (FilePath contentRoot : contentRoots) {
            VirtualFile repository;
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.startNonCancelableSection();
            }
            if ((repository = ProjectLevelVcsManager.getInstance((Project)this.project).getVcsRootFor(contentRoot)) == null) continue;
            try {
                HgRegularUpdater updater = new HgRegularUpdater(this.project, repository, this.updateConfiguration);
                result &= updater.update(updatedFiles, indicator, exceptions);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            if (indicator == null) continue;
            indicator.finishNonCancelableSection();
        }
        UpdateSessionAdapter updateSessionAdapter = new UpdateSessionAdapter(exceptions, !result);
        if (updateSessionAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/update/HgUpdateEnvironment", "updateDirectories"));
        }
        return updateSessionAdapter;
    }

    public Configurable createConfigurable(Collection<FilePath> contentRoots) {
        return new UpdateConfigurable(this.updateConfiguration);
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    public static class UpdateConfigurable
    implements Configurable {
        private final HgUpdateConfigurationSettings updateConfiguration;
        protected HgUpdateDialog updateDialog;

        public UpdateConfigurable(HgUpdateConfigurationSettings updateConfiguration) {
            this.updateConfiguration = updateConfiguration;
        }

        @Nls
        public String getDisplayName() {
            return "Update";
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            this.updateDialog = new HgUpdateDialog();
            return this.updateDialog.getContentPanel();
        }

        public boolean isModified() {
            return true;
        }

        public void apply() throws ConfigurationException {
            this.updateDialog.applyTo(this.updateConfiguration);
        }

        public void reset() {
            this.updateDialog.updateFrom(this.updateConfiguration);
        }

        public void disposeUIResources() {
            this.updateDialog = null;
        }
    }
}

