/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgHeadMerger {
    private static final Logger LOG = Logger.getInstance((String)HgHeadMerger.class.getName());
    private final Project project;
    private final HgMergeCommand hgMergeCommand;

    public HgHeadMerger(Project project, @NotNull HgMergeCommand hgMergeCommand) {
        if (hgMergeCommand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/update/HgHeadMerger", "<init>"));
        }
        this.project = project;
        this.hgMergeCommand = hgMergeCommand;
    }

    public HgCommandResult merge(VirtualFile repo) throws VcsException {
        HgCommandResult commandResult = HgErrorHandler.ensureSuccess(this.hgMergeCommand.execute());
        try {
            HgUtil.markDirectoryDirty(this.project, repo);
        }
        catch (InvocationTargetException e) {
            HgHeadMerger.throwException(e);
        }
        catch (InterruptedException e) {
            HgHeadMerger.throwException(e);
        }
        return commandResult;
    }

    private static void throwException(Exception e) throws VcsException {
        String msg = "Exception during marking directory dirty: " + e;
        LOG.info(msg, (Throwable)e);
        throw new VcsException(msg);
    }
}

