/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.dvcs.DvcsCommitAdditionalComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgPusher;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCheckinEnvironment
implements CheckinEnvironment {
    private final Project myProject;
    private boolean myNextCommitIsPushed;
    private boolean myNextCommitAmend;

    public HgCheckinEnvironment(Project project) {
        this.myProject = project;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        this.myNextCommitIsPushed = false;
        return new HgCommitAdditionalComponent(this.myProject, panel);
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return HgVcsMessages.message("hg4idea.commit", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        VirtualFile repo;
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "commit"));
        }
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        Map<VirtualFile, Set<HgFile>> repositoriesMap = this.getFilesByRepository(changes);
        for (Map.Entry<VirtualFile, Set<HgFile>> entry : repositoriesMap.entrySet()) {
            repo = entry.getKey();
            Set<HgFile> selectedFiles = entry.getValue();
            HgCommitCommand command = new HgCommitCommand(this.myProject, repo, preparedComment, this.myNextCommitAmend);
            if (this.isMergeCommit(repo)) {
                boolean partial;
                Set<HgFile> changedFilesNotInCommit = this.getChangedFilesNotInCommit(repo, selectedFiles);
                boolean bl = partial = !changedFilesNotInCommit.isEmpty();
                if (partial) {
                    StringBuilder filesNotIncludedString = new StringBuilder();
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        filesNotIncludedString.append("<li>");
                        filesNotIncludedString.append(hgFile.getRelativePath());
                        filesNotIncludedString.append("</li>");
                    }
                    if (!this.mayCommitEverything(filesNotIncludedString.toString())) {
                        return exceptions;
                    }
                }
            } else {
                command.setFiles(selectedFiles);
            }
            try {
                command.execute();
            }
            catch (HgCommandException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        if (this.myNextCommitIsPushed && exceptions.isEmpty()) {
            VirtualFile preselectedRepo = repositoriesMap.size() == 1 ? repositoriesMap.keySet().iterator().next() : null;
            HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(this.myProject);
            repo = preselectedRepo != null ? (HgRepository)repositoryManager.getRepositoryForFile(preselectedRepo) : null;
            final List repositories = repositoryManager.getRepositories();
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((HgRepository)repo){
                final /* synthetic */ HgRepository val$repo;
                {
                    this.val$repo = hgRepository;
                }

                @Override
                public void run() {
                    new HgPusher(HgCheckinEnvironment.this.myProject).showDialogAndPush(repositories, this.val$repo);
                }
            });
        }
        return exceptions;
    }

    private boolean isMergeCommit(VirtualFile repo) {
        return new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo).size() > 1;
    }

    private Set<HgFile> getChangedFilesNotInCommit(VirtualFile repo, Set<HgFile> selectedFiles) {
        List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo);
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).baseRevision(parents.get(0)).build(this.myProject);
        Set<HgChange> allChangedFilesInRepo = statusCommand.execute(repo);
        HashSet<HgFile> filesNotIncluded = new HashSet<HgFile>();
        for (HgChange change : allChangedFilesInRepo) {
            HgFile beforeFile = change.beforeFile();
            HgFile afterFile = change.afterFile();
            if (!selectedFiles.contains(beforeFile)) {
                filesNotIncluded.add(beforeFile);
                continue;
            }
            if (selectedFiles.contains(afterFile)) continue;
            filesNotIncluded.add(afterFile);
        }
        return filesNotIncluded;
    }

    private boolean mayCommitEverything(final String filesNotIncludedString) {
        final int[] choice = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                choice[0] = Messages.showOkCancelDialog((Project)HgCheckinEnvironment.this.myProject, (String)HgVcsMessages.message("hg4idea.commit.partial.merge.message", filesNotIncludedString), (String)HgVcsMessages.message("hg4idea.commit.partial.merge.title", new Object[0]), null);
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.defaultModalityState());
        } else {
            runnable.run();
        }
        return choice[0] == 0;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        final ArrayList<HgFile> filesWithRoots = new ArrayList<HgFile>();
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (vcsRoot == null) continue;
            filesWithRoots.add(new HgFile(vcsRoot, filePath));
        }
        new Task.Backgroundable(this.myProject, "Removing files..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$3", "run"));
                }
                HgRemoveCommand command = new HgRemoveCommand(this.myProject);
                command.execute(filesWithRoots);
            }
        }.queue();
        return null;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        new HgAddCommand(this.myProject).addWithProgress(files);
        return null;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @NotNull
    private Map<VirtualFile, Set<HgFile>> getFilesByRepository(List<Change> changes) {
        HashMap<VirtualFile, Set<HgFile>> result = new HashMap<VirtualFile, Set<HgFile>>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision != null) {
                this.addFile(result, afterRevision.getFile());
            }
            if (beforeRevision == null) continue;
            this.addFile(result, beforeRevision.getFile());
        }
        HashMap<VirtualFile, Set<HgFile>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "getFilesByRepository"));
        }
        return hashMap;
    }

    private void addFile(Map<VirtualFile, Set<HgFile>> result, FilePath filePath) {
        if (filePath == null) {
            return;
        }
        VirtualFile repo = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
        if (repo == null || filePath.isDirectory()) {
            return;
        }
        Set<HgFile> hgFiles = result.get(repo);
        if (hgFiles == null) {
            hgFiles = new HashSet<HgFile>();
            result.put(repo, hgFiles);
        }
        hgFiles.add(new HgFile(repo, filePath));
    }

    public void setNextCommitIsPushed() {
        this.myNextCommitIsPushed = true;
    }

    private class HgCommitAdditionalComponent
    extends DvcsCommitAdditionalComponent {
        public HgCommitAdditionalComponent(@NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "<init>"));
            }
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "<init>"));
            }
            super(project, panel);
            HgVcs myVcs = HgVcs.getInstance(HgCheckinEnvironment.this.myProject);
            this.myAmend.setEnabled(myVcs != null && myVcs.getVersion().isAmendSupported());
        }

        public void refresh() {
            super.refresh();
            HgCheckinEnvironment.this.myNextCommitAmend = false;
        }

        public void saveState() {
            HgCheckinEnvironment.this.myNextCommitAmend = this.myAmend.isSelected();
        }

        public void restoreState() {
            HgCheckinEnvironment.this.myNextCommitAmend = false;
        }

        @NotNull
        protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> filePaths) {
            if (filePaths == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "getVcsRoots"));
            }
            Set<VirtualFile> set = HgUtil.hgRoots(HgCheckinEnvironment.this.myProject, filePaths);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "getVcsRoots"));
            }
            return set;
        }

        @Nullable
        protected String getLastCommitMessage(@NotNull VirtualFile repo) throws VcsException {
            if (repo == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "getLastCommitMessage"));
            }
            HgCommandExecutor commandExecutor = new HgCommandExecutor(HgCheckinEnvironment.this.myProject);
            ArrayList<String> args = new ArrayList<String>();
            args.add("-r");
            args.add(".");
            args.add("--template");
            args.add("{desc}");
            HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "log", args, null);
            return result == null ? "" : result.getRawOutput();
        }
    }
}

