/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgRevertCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRollbackEnvironment
implements RollbackEnvironment {
    private final Project project;

    public HgRollbackEnvironment(Project project) {
        this.project = project;
    }

    public String getRollbackOperationName() {
        return HgVcsMessages.message("hg4idea.revert", new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/HgRollbackEnvironment", "rollbackChanges"));
        }
        if (changes == null || changes.isEmpty()) {
            return;
        }
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        LinkedList<FilePath> filePaths = new LinkedList<FilePath>();
        for (Change change : changes) {
            ContentRevision contentRevision = Change.Type.DELETED == change.getType() ? change.getBeforeRevision() : change.getAfterRevision();
            if (contentRevision == null) continue;
            filePaths.add(contentRevision.getFile());
            if (Change.Type.MOVED != change.getType()) continue;
            toDelete.add(contentRevision.getFile());
        }
        this.revert(filePaths);
        for (FilePath file : toDelete) {
            listener.accept(file);
            try {
                File ioFile = file.getIOFile();
                if (!ioFile.exists() || ioFile.delete()) continue;
                vcsExceptions.add(new VcsException("Unable to delete file: " + file));
            }
            catch (Exception e) {
                vcsExceptions.add(new VcsException("Unable to delete file: " + file, (Throwable)e));
            }
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        this.revert(files);
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
    }

    public List<VcsException> rollbackMissingFileDeletion(List<FilePath> files) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        this.revert(files);
        return null;
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void revert(List<FilePath> filePaths) {
        for (Map.Entry<VirtualFile, Collection<FilePath>> entry : HgUtil.groupFilePathsByHgRoots(this.project, filePaths).entrySet()) {
            VirtualFile repo = entry.getKey();
            Collection<FilePath> files = entry.getValue();
            HgRevisionNumber revisionNumber = new HgWorkingCopyRevisionsCommand(this.project).firstParent(repo);
            new HgRevertCommand(this.project).execute(repo, files, revisionNumber, false);
            new HgResolveCommand(this.project).markResolved(repo, files);
        }
    }
}

