/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMergeProvider
implements MergeProvider {
    private static final Logger LOG = Logger.getInstance((String)HgMergeProvider.class.getName());
    private final Project myProject;

    public HgMergeProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public MergeData loadRevisions(final VirtualFile file) throws VcsException {
        final MergeData mergeData = new MergeData();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                HgContentRevision base;
                HgRevisionNumber serverRevisionNumber;
                HgWorkingCopyRevisionsCommand command = new HgWorkingCopyRevisionsCommand(HgMergeProvider.this.myProject);
                VirtualFile repo = HgUtil.getHgRootOrThrow(HgMergeProvider.this.myProject, file);
                HgFile hgFile = new HgFile(HgMergeProvider.this.myProject, file);
                HgRevisionNumber baseRevisionNumber = null;
                if (HgMergeProvider.this.wasFileCheckedIn(repo, file)) {
                    Pair<HgRevisionNumber, HgRevisionNumber> parents = command.parents(repo, file);
                    serverRevisionNumber = (HgRevisionNumber)parents.second;
                    HgRevisionNumber localRevisionNumber = (HgRevisionNumber)parents.first;
                    HgContentRevision local = new HgContentRevision(HgMergeProvider.this.myProject, hgFile, localRevisionNumber);
                    mergeData.CURRENT = local.getContentAsBytes();
                    ArrayList<String> arguments = new ArrayList<String>();
                    String localChangeset = localRevisionNumber.getChangeset();
                    String serverChangeset = serverRevisionNumber.getChangeset();
                    arguments.add(StringUtil.isEmptyOrSpaces((String)localChangeset) ? localRevisionNumber.getRevision() : localChangeset);
                    arguments.add(StringUtil.isEmptyOrSpaces((String)serverChangeset) ? serverRevisionNumber.getRevision() : serverChangeset);
                    HgCommandResult result = new HgCommandExecutor(HgMergeProvider.this.myProject).executeInCurrentThread(repo, "debugancestor", arguments);
                    if (result != null) {
                        String output = result.getRawOutput();
                        List parts = StringUtil.split((String)output, (String)":");
                        if (parts.size() < 2) {
                            LOG.info("Couldn't parse result of debugancestor command execution " + arguments);
                            new HgCommandResultNotifier(HgMergeProvider.this.myProject).notifyError(null, HgVcsMessages.message("hg4idea.error.debugancestor.command.execution", new Object[0]), HgVcsMessages.message("hg4idea.error.debugancestor.command.description", new Object[0]));
                        } else {
                            baseRevisionNumber = HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1));
                        }
                    } else {
                        LOG.info(HgVcsMessages.message("hg4idea.error.debugancestor.command.execution", new Object[0]) + arguments);
                        new HgCommandResultNotifier(HgMergeProvider.this.myProject).notifyError(null, HgVcsMessages.message("hg4idea.error.debugancestor.command.execution", new Object[0]), HgVcsMessages.message("hg4idea.error.debugancestor.command.description", new Object[0]));
                    }
                } else {
                    serverRevisionNumber = (HgRevisionNumber)command.parents((VirtualFile)repo, (VirtualFile)file).first;
                    baseRevisionNumber = (HgRevisionNumber)command.parents((VirtualFile)repo, (VirtualFile)file, (HgRevisionNumber)serverRevisionNumber).first;
                    File origFile = new File(file.getPath() + ".orig");
                    try {
                        mergeData.CURRENT = VcsUtil.getFileByteContent((File)origFile);
                    }
                    catch (IOException e) {
                        LOG.info("Couldn't retrieve byte content of the file: " + origFile.getPath(), (Throwable)e);
                    }
                }
                mergeData.ORIGINAL = baseRevisionNumber != null ? ((base = new HgContentRevision(HgMergeProvider.this.myProject, hgFile, baseRevisionNumber)).getContent() != null ? base.getContentAsBytes() : new byte[]{}) : new byte[0];
                HgContentRevision server = new HgContentRevision(HgMergeProvider.this.myProject, hgFile, serverRevisionNumber);
                mergeData.LAST = server.getContentAsBytes();
                file.refresh(false, false);
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)VcsBundle.message((String)"multiple.file.merge.loading.progress.title", (Object[])new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData2 = mergeData;
        if (mergeData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgMergeProvider", "loadRevisions"));
        }
        return mergeData2;
    }

    public void conflictResolvedForFile(VirtualFile file) {
        try {
            new HgResolveCommand(this.myProject).markResolved(HgUtil.getHgRootOrThrow(this.myProject, file), file);
        }
        catch (VcsException e) {
            LOG.error("Couldn't mark file resolved, because it is not under Mercurial root.");
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgMergeProvider", "isBinary"));
        }
        return file.getFileType().isBinary();
    }

    private boolean wasFileCheckedIn(VirtualFile repo, VirtualFile file) {
        Pair<HgRevisionNumber, HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo, file);
        return parents.second != null;
    }
}

