/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;

public class HgCommittedChangeList
extends CommittedChangeListImpl
implements VcsRevisionNumberAware {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private HgRevisionNumber myRevision;
    @NotNull
    private String myBranch;

    public HgCommittedChangeList(@NotNull HgVcs vcs, @NotNull HgRevisionNumber revision, @NotNull String branch, String comment, String committerName, Date commitDate, Collection<Change> changes) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "<init>"));
        }
        super(revision.asString() + ": " + comment, comment, committerName, revision.getRevisionAsLong(), commitDate, changes);
        this.myVcs = vcs;
        this.myRevision = revision;
        this.myBranch = StringUtil.isEmpty((String)branch) ? "default" : branch;
    }

    @NotNull
    public HgRevisionNumber getRevision() {
        HgRevisionNumber hgRevisionNumber = this.myRevision;
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "getRevision"));
        }
        return hgRevisionNumber;
    }

    @NotNull
    public String getBranch() {
        String string = this.myBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "getBranch"));
        }
        return string;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public String toString() {
        return this.getComment();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevision;
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCommittedChangeList", "getRevisionNumber"));
        }
        return hgRevisionNumber;
    }
}

