/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCloneCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.ui.HgCloneDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(final @NotNull Project project, final @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgCheckoutProvider", "doCheckout"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        final HgCloneDialog dialog = new HgCloneDialog(project);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.rememberSettings();
        VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            return;
        }
        final String targetDir = destinationParent.getPath() + File.separator + dialog.getDirectoryName();
        final String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.clone.progress", sourceRepositoryURL), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgCheckoutProvider$2", "run"));
                }
                HgCloneCommand clone = new HgCloneCommand(project);
                clone.setRepositoryURL(sourceRepositoryURL);
                clone.setDirectory(targetDir);
                HgCommandResult myCloneResult = clone.execute();
                if (myCloneResult == null || HgErrorUtil.hasErrorsInCommandExecution(myCloneResult)) {
                    new HgCommandResultNotifier(project).notifyError(myCloneResult, "Clone failed", "Clone from " + sourceRepositoryURL + " failed.");
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                listener.directoryCheckedOut(new File(dialog.getParentDirectory(), dialog.getDirectoryName()), HgVcs.getKey());
                                listener.checkoutCompleted();
                            }
                        }
                    });
                }
            }
        }.queue();
    }

    public String getVcsName() {
        return "_Mercurial";
    }
}

