/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.log.HgRefManager;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgHistoryUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgLogProvider
implements VcsLogProvider {
    private static final Logger LOG = Logger.getInstance(HgLogProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepositoryManager myRepositoryManager;
    @NotNull
    private final VcsLogRefManager myRefSorter;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;
    private static final String RECENT_HEAD = "tip";

    public HgLogProvider(@NotNull Project project, @NotNull HgRepositoryManager repositoryManager, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/log/HgLogProvider", "<init>"));
        }
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myRefSorter = new HgRefManager();
        this.myVcsObjectsFactory = factory;
    }

    @NotNull
    public List<? extends VcsCommitMetadata> readFirstBlock(@NotNull VirtualFile root, boolean ordered, int commitCount) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "readFirstBlock"));
        }
        List<? extends VcsCommitMetadata> list = HgHistoryUtil.loadMetadata(this.myProject, root, commitCount, ordered ? Collections.emptyList() : Arrays.asList("-r", "0:tip"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readFirstBlock"));
        }
        return list;
    }

    @NotNull
    public List<TimedVcsCommit> readAllHashes(@NotNull VirtualFile root, @NotNull Consumer<VcsUser> userRegistry) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        List<TimedVcsCommit> list = HgHistoryUtil.readAllHashes(this.myProject, root, userRegistry, Collections.<String>emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllHashes"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsShortCommitDetails> readShortDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        List<? extends VcsShortCommitDetails> list = HgHistoryUtil.readMiniDetails(this.myProject, root, hashes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readShortDetails"));
        }
        return list;
    }

    @NotNull
    public List<? extends VcsFullCommitDetails> readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        List<? extends VcsFullCommitDetails> list = HgHistoryUtil.history(this.myProject, root, -1, HgHistoryUtil.prepareHashes(hashes));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readFullDetails"));
        }
        return list;
    }

    @NotNull
    public Collection<VcsRef> readAllRefs(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
        }
        this.myRepositoryManager.waitUntilInitialized();
        HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            List<VcsRef> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
            }
            return list;
        }
        repository.update();
        Map<String, Set<Hash>> branches = repository.getBranches();
        Set<String> openedBranchNames = repository.getOpenedBranches();
        Collection<HgNameWithHashInfo> bookmarks = repository.getBookmarks();
        Collection<HgNameWithHashInfo> tags = repository.getTags();
        Collection<HgNameWithHashInfo> localTags = repository.getLocalTags();
        ArrayList<VcsRef> refs = new ArrayList<VcsRef>(branches.size() + bookmarks.size());
        for (Map.Entry<String, Set<Hash>> entry : branches.entrySet()) {
            String branchName = entry.getKey();
            boolean opened = openedBranchNames.contains(branchName);
            for (Hash hash : entry.getValue()) {
                refs.add(this.myVcsObjectsFactory.createRef(hash, branchName, opened ? HgRefManager.BRANCH : HgRefManager.CLOSED_BRANCH, root));
            }
        }
        for (HgNameWithHashInfo bookmarkInfo : bookmarks) {
            refs.add(this.myVcsObjectsFactory.createRef(bookmarkInfo.getHash(), bookmarkInfo.getName(), HgRefManager.BOOKMARK, root));
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            refs.add(this.myVcsObjectsFactory.createRef(this.myVcsObjectsFactory.createHash(currentRevision), RECENT_HEAD, HgRefManager.HEAD, root));
        }
        for (HgNameWithHashInfo tagInfo : tags) {
            refs.add(this.myVcsObjectsFactory.createRef(tagInfo.getHash(), tagInfo.getName(), HgRefManager.TAG, root));
        }
        for (HgNameWithHashInfo localTagInfo : localTags) {
            refs.add(this.myVcsObjectsFactory.createRef(localTagInfo.getHash(), localTagInfo.getName(), HgRefManager.LOCAL_TAG, root));
        }
        ArrayList<VcsRef> arrayList = refs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "readAllRefs"));
        }
        return arrayList;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public VcsLogRefManager getReferenceManager() {
        VcsLogRefManager vcsLogRefManager = this.myRefSorter;
        if (vcsLogRefManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getReferenceManager"));
        }
        return vcsLogRefManager;
    }

    public void subscribeToRootRefreshEvents(final @NotNull Collection<VirtualFile> roots, final @NotNull VcsLogRefresher refresher) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "subscribeToRootRefreshEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "subscribeToRootRefreshEvents"));
        }
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(HgVcs.STATUS_TOPIC, (Object)new HgUpdater(){

            @Override
            public void update(Project project, @Nullable VirtualFile root) {
                if (root != null && roots.contains(root)) {
                    refresher.refresh(root);
                }
            }
        });
    }

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile root, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        ArrayList filterParameters = ContainerUtil.newArrayList();
        if (filterCollection.getBranchFilter() != null) {
            HgRepository repository = (HgRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository not found for root " + root);
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
            boolean atLeastOneBranchExists = false;
            for (String branchName : filterCollection.getBranchFilter().getBranchNames()) {
                if (!branchName.equals(RECENT_HEAD) && !HgLogProvider.branchExists(repository, branchName)) continue;
                filterParameters.add(HgLogProvider.prepareParameter("branch", branchName));
                atLeastOneBranchExists = true;
            }
            if (!atLeastOneBranchExists) {
                List<TimedVcsCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
                }
                return list;
            }
        }
        if (filterCollection.getUserFilter() != null) {
            for (String authorName : filterCollection.getUserFilter().getUserNames(root)) {
                filterParameters.add(HgLogProvider.prepareParameter("user", authorName));
            }
        }
        if (filterCollection.getDateFilter() != null) {
            StringBuilder args = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            filterParameters.add("-r");
            VcsLogDateFilter filter = filterCollection.getDateFilter();
            if (filter.getAfter() != null) {
                args.append("date('>").append(dateFormatter.format(filter.getAfter())).append("')");
            }
            if (filter.getBefore() != null) {
                if (args.length() > 0) {
                    args.append(" and ");
                }
                args.append("date('<").append(dateFormatter.format(filter.getBefore())).append("')");
            }
            filterParameters.add(args.toString());
        }
        if (filterCollection.getTextFilter() != null) {
            String textFilter = filterCollection.getTextFilter().getText();
            filterParameters.add(HgLogProvider.prepareParameter("keyword", textFilter));
        }
        if (filterCollection.getStructureFilter() != null) {
            for (VirtualFile file : filterCollection.getStructureFilter().getFiles(root)) {
                filterParameters.add(file.getPath());
            }
        }
        List<TimedVcsCommit> list = HgHistoryUtil.readAllHashes(this.myProject, root, (Consumer<VcsUser>)Consumer.EMPTY_CONSUMER, filterParameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getCommitsMatchingFilter"));
        }
        return list;
    }

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "getCurrentUser"));
        }
        String userName = HgConfig.getInstance(this.myProject, root).getNamedConfig("ui", "username");
        if (userName == null && (userName = System.getenv("HGUSER")) == null && (userName = System.getenv("USER")) == null && (userName = System.getenv("LOGNAME")) == null) {
            return null;
        }
        Pair<String, String> userArgs = HgUtil.parseUserNameAndEmail(userName);
        return this.myVcsObjectsFactory.createUser((String)userArgs.getFirst(), (String)userArgs.getSecond());
    }

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile root, @NotNull Hash commitHash) throws VcsException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        Collection<String> collection = HgHistoryUtil.getDescendingHeadsOfBranches(this.myProject, root, commitHash);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgLogProvider", "getContainingBranches"));
        }
        return collection;
    }

    public boolean supportsFastUnorderedCommits() {
        return false;
    }

    private static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    private static boolean branchExists(@NotNull HgRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgLogProvider", "branchExists"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgLogProvider", "branchExists"));
        }
        return repository.getBranches().keySet().contains(branchName) || HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(branchName);
    }
}

