/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.ContentRevisionFactory;
import com.intellij.vcs.log.Hash;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;

public class HgContentRevisionFactory
extends ContentRevisionFactory {
    @NotNull
    private final Project myProject;

    private HgContentRevisionFactory(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "<init>"));
        }
        this.myProject = project;
    }

    public static HgContentRevisionFactory getInstance(Project project) {
        return (HgContentRevisionFactory)((Object)ServiceManager.getService((Project)project, HgContentRevisionFactory.class));
    }

    @NotNull
    public ContentRevision createRevision(@NotNull VirtualFile file, @NotNull Hash hash) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        HgContentRevision hgContentRevision = new HgContentRevision(this.myProject, new HgFile(this.myProject, file), HgRevisionNumber.getInstance("", hash.asString()));
        if (hgContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        return hgContentRevision;
    }

    @NotNull
    public ContentRevision createRevision(@NotNull VirtualFile root, @NotNull String path, @NotNull Hash hash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        HgContentRevision hgContentRevision = new HgContentRevision(this.myProject, new HgFile(root, new File(path)), HgRevisionNumber.getInstance("", hash.asString()));
        if (hgContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgContentRevisionFactory", "createRevision"));
        }
        return hgContentRevision;
    }
}

