/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.util.text.LineTokenizer;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

public final class HgCommandResult {
    public static final HgCommandResult EMPTY = new HgCommandResult(new StringWriter(), new StringWriter(), 0);
    public static final HgCommandResult CANCELLED = new HgCommandResult(new StringWriter(), new StringWriter(), 1);
    private final StringWriter out;
    private final StringWriter err;
    private final int exitValue;
    private List<String> outLines;
    private List<String> errLines;
    private String warnings;

    public HgCommandResult(StringWriter out, StringWriter err, int exitValue) {
        this.out = out;
        this.err = err;
        this.exitValue = exitValue;
    }

    public List<String> getOutputLines() {
        if (this.outLines == null) {
            this.outLines = Arrays.asList(LineTokenizer.tokenize((CharSequence)this.out.getBuffer(), (boolean)false));
        }
        return this.outLines;
    }

    public List<String> getErrorLines() {
        if (this.errLines == null) {
            this.errLines = Arrays.asList(LineTokenizer.tokenize((CharSequence)this.err.getBuffer(), (boolean)false));
        }
        return this.errLines;
    }

    public String getRawOutput() {
        return this.out.toString();
    }

    public String getRawError() {
        return this.err.toString();
    }

    public int getExitValue() {
        return this.exitValue;
    }

    void setWarnings(String warnings) {
        this.warnings = warnings;
    }

    public String getWarnings() {
        return this.warnings;
    }
}

