/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandAuthenticator;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.execution.HgPromptChoice;
import org.zmlx.hg4idea.execution.HgPromptHandler;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.execution.SocketServer;
import org.zmlx.hg4idea.util.HgEncodingUtil;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgCommandExecutor {
    private static final Logger LOG = Logger.getInstance((String)HgCommandExecutor.class.getName());
    private static final List<String> DEFAULT_OPTIONS = Arrays.asList("--config", "ui.merge=internal:merge");
    private final Project myProject;
    private final HgVcs myVcs;
    private final String myDestination;
    @NotNull
    private Charset myCharset;
    private boolean myIsSilent = false;
    private boolean myShowOutput = false;
    private boolean myOutputAlwaysSuppressed = false;
    private List<String> myOptions = DEFAULT_OPTIONS;
    @Nullable
    private ModalityState myState;

    public HgCommandExecutor(Project project) {
        this(project, null);
    }

    public HgCommandExecutor(Project project, @Nullable String destination) {
        this(project, destination, null);
    }

    public HgCommandExecutor(Project project, @Nullable String destination, @Nullable ModalityState state) {
        this.myProject = project;
        this.myVcs = HgVcs.getInstance(project);
        this.myDestination = destination;
        this.myState = state;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
    }

    public void setCharset(@Nullable Charset charset) {
        if (charset != null) {
            this.myCharset = charset;
        }
    }

    public void setSilent(boolean isSilent) {
        this.myIsSilent = isSilent;
    }

    public void setOptions(List<String> options) {
        this.myOptions = options;
    }

    public void setShowOutput(boolean showOutput) {
        this.myShowOutput = showOutput;
    }

    public void setOutputAlwaysSuppressed(boolean outputAlwaysSuppressed) {
        this.myOutputAlwaysSuppressed = outputAlwaysSuppressed;
    }

    public void execute(final @Nullable VirtualFile repo, final @NotNull String operation, final @Nullable List<String> arguments, final @Nullable HgCommandResultHandler handler) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/execution/HgCommandExecutor", "execute"));
        }
        HgUtil.executeOnPooledThreadIfNeeded(new Runnable(){

            @Override
            public void run() {
                HgCommandResult result = HgCommandExecutor.this.executeInCurrentThread(repo, operation, arguments);
                if (handler != null) {
                    handler.process(result);
                }
            }
        });
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/execution/HgCommandExecutor", "executeInCurrentThread"));
        }
        return this.executeInCurrentThread(repo, operation, arguments, null);
    }

    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, @Nullable HgPromptHandler handler) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/execution/HgCommandExecutor", "executeInCurrentThread"));
        }
        HgCommandResult result = this.executeInCurrentThread(repo, operation, arguments, handler, false);
        if (HgErrorUtil.isUnknownEncodingError(result)) {
            this.setCharset(Charset.forName("utf8"));
            result = this.executeInCurrentThread(repo, operation, arguments, handler, false);
        }
        if (HgErrorUtil.isAuthorizationError(result)) {
            if (HgErrorUtil.hasAuthorizationInDestinationPath(this.myDestination)) {
                new HgCommandResultNotifier(this.myProject).notifyError(result, "Authorization failed", "Your hgrc file settings have wrong username or password in [paths].\nPlease, update your .hg/hgrc file.");
                return null;
            }
            result = this.executeInCurrentThread(repo, operation, arguments, handler, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments, @Nullable HgPromptHandler handler, boolean forceAuthorization) {
        HgCommandResult result;
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/execution/HgCommandExecutor", "executeInCurrentThread"));
        }
        if (this.myProject == null || this.myProject.isDisposed() || this.myVcs == null) {
            return null;
        }
        this.logCommand(operation, arguments);
        LinkedList<String> cmdLine = new LinkedList<String>();
        cmdLine.add(this.myVcs.getGlobalSettings().getHgExecutable());
        if (repo != null) {
            cmdLine.add("--repository");
            cmdLine.add(repo.getPath());
        }
        WarningReceiver warningReceiver = new WarningReceiver();
        PassReceiver passReceiver = new PassReceiver(this.myProject, forceAuthorization, this.myState);
        SocketServer promptServer = new SocketServer(new PromptReceiver(handler));
        SocketServer warningServer = new SocketServer(warningReceiver);
        SocketServer passServer = new SocketServer(passReceiver);
        try {
            int promptPort = promptServer.start();
            int warningPort = warningServer.start();
            int passPort = passServer.start();
            cmdLine.add("--config");
            cmdLine.add("extensions.hg4ideapromptextension=" + this.myVcs.getPromptHooksExtensionFile().getAbsolutePath());
            cmdLine.add("--config");
            cmdLine.add("hg4ideaprompt.port=" + promptPort);
            cmdLine.add("--config");
            cmdLine.add("hg4ideawarn.port=" + warningPort);
            cmdLine.add("--config");
            cmdLine.add("hg4ideapass.port=" + passPort);
            cmdLine.add("--config");
            cmdLine.add("extensions.mq=");
        }
        catch (IOException e) {
            this.showError(e);
            LOG.info("IOException during preparing command", (Throwable)e);
            promptServer.stop();
            warningServer.stop();
            passServer.stop();
            return null;
        }
        cmdLine.addAll(this.myOptions);
        cmdLine.add(operation);
        if (arguments != null && arguments.size() != 0) {
            cmdLine.addAll(arguments);
        }
        if (HgVcs.HGENCODING == null) {
            cmdLine.add("--encoding");
            cmdLine.add(HgEncodingUtil.getNameFor(this.myCharset));
        }
        try {
            String workingDir = repo != null ? repo.getPath() : null;
            ShellCommand shellCommand = new ShellCommand(cmdLine, workingDir, this.myCharset);
            long startTime = System.currentTimeMillis();
            LOG.debug(String.format("hg %s started", operation));
            result = shellCommand.execute(this.myShowOutput);
            LOG.debug(String.format("hg %s finished. Took %s ms", operation, System.currentTimeMillis() - startTime));
            if (!HgErrorUtil.isAuthorizationError(result)) {
                passReceiver.saveCredentials();
            }
        }
        catch (ShellCommandException e) {
            if (this.myVcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
                this.showError(e);
                LOG.info(e.getMessage(), (Throwable)e);
            }
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        catch (InterruptedException e) {
            LOG.info(e.getMessage(), (Throwable)e);
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        finally {
            promptServer.stop();
            warningServer.stop();
            passServer.stop();
        }
        String warnings = warningReceiver.getWarnings();
        result.setWarnings(warnings);
        this.logResult(result);
        return result;
    }

    private void logCommand(@NotNull String operation, @Nullable List<String> arguments) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/execution/HgCommandExecutor", "logCommand"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        HgGlobalSettings settings = this.myVcs.getGlobalSettings();
        int lastSlashIndex = settings.getHgExecutable().lastIndexOf(File.separator);
        String exeName = settings.getHgExecutable().substring(lastSlashIndex + 1);
        String str = String.format("%s %s %s", exeName, operation, arguments == null ? "" : StringUtil.join(arguments, (String)" "));
        String cmdString = this.myDestination != null ? HgUtil.removePasswordIfNeeded(str) : str;
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (isUnitTestMode) {
            System.out.print(cmdString + "\n");
        }
        if (!this.myIsSilent) {
            LOG.info(cmdString);
            this.myVcs.showMessageInConsole(cmdString, ConsoleViewContentType.NORMAL_OUTPUT.getAttributes());
        } else {
            LOG.debug(cmdString);
        }
    }

    private void logResult(@NotNull HgCommandResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/execution/HgCommandExecutor", "logResult"));
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!result.getRawOutput().isEmpty()) {
            if (unitTestMode) {
                System.out.print(result.getRawOutput() + "\n");
            } else if (!this.myOutputAlwaysSuppressed) {
                if (!this.myIsSilent && this.myShowOutput) {
                    LOG.info(result.getRawOutput());
                    this.myVcs.showMessageInConsole(result.getRawOutput(), ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes());
                } else {
                    LOG.debug(result.getRawOutput());
                }
            }
        }
        if (!result.getRawError().isEmpty()) {
            if (unitTestMode) {
                System.out.print(result.getRawError() + "\n");
            }
            if (!this.myIsSilent) {
                LOG.info(result.getRawError());
                this.myVcs.showMessageInConsole(result.getRawError(), ConsoleViewContentType.ERROR_OUTPUT.getAttributes());
            } else {
                LOG.debug(result.getRawError());
            }
        }
    }

    private void showError(Exception e) {
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append(HgVcsMessages.message("hg4idea.command.executable.error", vcs.getGlobalSettings().getHgExecutable())).append("\n").append("Original Error:\n").append(e.getMessage());
        VcsImplUtil.showErrorMessage((Project)this.myProject, (String)message.toString(), (String)HgVcsMessages.message("hg4idea.error", new Object[0]));
    }

    private static class PassReceiver
    extends SocketServer.Protocol {
        private final Project myProject;
        private HgCommandAuthenticator myAuthenticator;
        private boolean myForceAuthorization;
        @Nullable
        private ModalityState myState;

        private PassReceiver(Project project, boolean forceAuthorization, @Nullable ModalityState state) {
            this.myProject = project;
            this.myForceAuthorization = forceAuthorization;
            this.myState = state;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String command = new String(PassReceiver.readDataBlock(dataInputStream));
            assert ("getpass".equals(command)) : "Invalid command: " + command;
            String uri = new String(PassReceiver.readDataBlock(dataInputStream));
            String path = new String(PassReceiver.readDataBlock(dataInputStream));
            HgCommandAuthenticator authenticator = new HgCommandAuthenticator(this.myProject, this.myForceAuthorization);
            String proposedLogin = new String(PassReceiver.readDataBlock(dataInputStream));
            boolean ok = authenticator.promptForAuthentication(this.myProject, proposedLogin, uri, path, this.myState);
            if (ok) {
                this.myAuthenticator = authenticator;
                PassReceiver.sendDataBlock(out, authenticator.getUserName().getBytes());
                PassReceiver.sendDataBlock(out, authenticator.getPassword().getBytes());
            }
            return true;
        }

        public void saveCredentials() {
            if (this.myAuthenticator == null) {
                return;
            }
            this.myAuthenticator.saveCredentials();
        }
    }

    private static class PromptReceiver
    extends SocketServer.Protocol {
        @Nullable
        HgPromptHandler myHandler;

        public PromptReceiver(@Nullable HgPromptHandler handler) {
            this.myHandler = handler;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInput = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            final String message = new String(PromptReceiver.readDataBlock(dataInput));
            int numOfChoices = dataInput.readInt();
            final HgPromptChoice[] choices = new HgPromptChoice[numOfChoices];
            for (int i = 0; i < numOfChoices; ++i) {
                String choice = new String(PromptReceiver.readDataBlock(dataInput));
                choices[i] = new HgPromptChoice(i, choice);
            }
            int defaultChoiceInt = dataInput.readInt();
            final HgPromptChoice defaultChoice = choices[defaultChoiceInt];
            if (this.myHandler != null && this.myHandler.shouldHandle(message)) {
                int chosen = this.myHandler.promptUser(message, choices, defaultChoice).getChosenIndex();
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            final int[] index = new int[]{-1};
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String[] choicePresentationArray = new String[choices.length];
                        for (int i = 0; i < choices.length; ++i) {
                            choicePresentationArray[i] = choices[i].toString();
                        }
                        index[0] = Messages.showDialog((String)message, (String)"hg4idea", (String[])choicePresentationArray, (int)defaultChoice.getChosenIndex(), (Icon)Messages.getQuestionIcon());
                    }
                });
                int chosen = index[0];
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private static void sendChoiceToHg(@NotNull DataOutputStream outStream, int choice) throws IOException {
            if (outStream == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/execution/HgCommandExecutor$PromptReceiver", "sendChoiceToHg"));
            }
            if (choice == -1) {
                outStream.writeInt(-1);
            } else {
                outStream.writeInt(choice);
            }
        }
    }

    private static class WarningReceiver
    extends SocketServer.Protocol {
        private StringBuffer warnings = new StringBuffer();

        private WarningReceiver() {
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInput = new DataInputStream(socket.getInputStream());
            int numOfWarnings = dataInput.readInt();
            for (int i = 0; i < numOfWarnings; ++i) {
                this.warnings.append(new String(WarningReceiver.readDataBlock(dataInput)));
            }
            return true;
        }

        public String getWarnings() {
            return this.warnings.toString();
        }
    }
}

