/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgDeleteModifyPromptHandler;

public class HgUpdateCommand {
    private final Project project;
    private final VirtualFile repo;
    private String branch;
    private String revision;
    private boolean clean;

    public HgUpdateCommand(Project project, @NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgUpdateCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    @Nullable
    public HgCommandResult execute() {
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.clean) {
            arguments.add("--clean");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        } else if (!StringUtil.isEmptyOrSpaces((String)this.branch)) {
            arguments.add(this.branch);
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.project);
        executor.setShowOutput(true);
        HgCommandResult result = executor.executeInCurrentThread(this.repo, "update", arguments, new HgDeleteModifyPromptHandler());
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.repo});
        return result;
    }
}

