/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;

public class HgRevertCommand {
    private final Project project;

    public HgRevertCommand(Project project) {
        this.project = project;
    }

    public void execute(VirtualFile repo, Collection<FilePath> files, HgRevisionNumber vcsRevisionNumber, boolean backupFile) {
        LinkedList<String> options = new LinkedList<String>();
        if (vcsRevisionNumber != null && !HgRevisionNumber.NULL_REVISION_NUMBER.equals(vcsRevisionNumber)) {
            options.add("--rev");
            if (!StringUtil.isEmptyOrSpaces((String)vcsRevisionNumber.getChangeset())) {
                options.add(vcsRevisionNumber.getChangeset());
            } else {
                options.add(vcsRevisionNumber.getRevision());
            }
        }
        if (!backupFile) {
            options.add("--no-backup");
        }
        for (List chunk : VcsFileUtil.chunkPaths((VirtualFile)repo, files)) {
            LinkedList<String> args = new LinkedList<String>();
            args.addAll(options);
            args.addAll(chunk);
            new HgCommandExecutor(this.project).executeInCurrentThread(repo, "revert", args);
        }
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
    }
}

