/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgLogCommand {
    private static final Logger LOG = Logger.getInstance((String)HgLogCommand.class.getName());
    private static final int REVISION_INDEX = 0;
    private static final int CHANGESET_INDEX = 1;
    private static final int PARENTS_INDEX = 2;
    private static final int DATE_INDEX = 3;
    private static final int AUTHOR_INDEX = 4;
    private static final int BRANCH_INDEX = 5;
    private static final int MESSAGE_INDEX = 6;
    private static final int FILES_ADDED_INDEX = 7;
    private static final int FILES_MODIFIED_INDEX = 8;
    private static final int FILES_DELETED_INDEX = 9;
    private static final int FILES_COPIED_INDEX = 10;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    @NotNull
    private final Project myProject;
    @NotNull
    private HgVersion myVersion;
    private boolean myIncludeRemoved;
    private boolean myFollowCopies;
    private boolean myLogFile;
    private boolean myLargeFilesWithFollowSupported;

    public void setIncludeRemoved(boolean includeRemoved) {
        this.myIncludeRemoved = includeRemoved;
    }

    public void setFollowCopies(boolean followCopies) {
        this.myFollowCopies = followCopies;
    }

    public void setLogFile(boolean logFile) {
        this.myLogFile = logFile;
    }

    public HgLogCommand(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgLogCommand", "<init>"));
        }
        this.myLogFile = true;
        this.myLargeFilesWithFollowSupported = false;
        this.myProject = project;
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            LOG.info("Vcs couldn't be null for project");
            return;
        }
        this.myVersion = vcs.getVersion();
        this.myLargeFilesWithFollowSupported = this.myVersion.isLargeFilesWithFollowSupported();
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles) throws HgCommandException {
        return this.execute(hgFile, limit, includeFiles, null);
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles, @Nullable List<String> argsForCmd) throws HgCommandException {
        String[] changeSets;
        if (limit <= 0 && limit != -1 || hgFile == null) {
            return Collections.emptyList();
        }
        String[] templates = HgLogCommand.constructTemplateArgument(includeFiles, this.myVersion);
        String template = HgChangesetUtil.makeTemplate(templates);
        int expectedItemCount = templates.length;
        boolean shouldParseOldTemplate = !this.myVersion.isBuiltInFunctionSupported();
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject));
        HgFile originalHgFile = new HgFile(hgFile.getRepo(), originalFileName);
        HgCommandResult result = this.execute(hgFile.getRepo(), template, limit, originalHgFile, argsForCmd);
        LinkedList<HgFileRevision> revisions = new LinkedList<HgFileRevision>();
        if (result == null) {
            return revisions;
        }
        List<String> errors = result.getErrorLines();
        if (errors != null && !errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                throw new HgCommandException(errors.toString());
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        for (String line : changeSets = output.split("\u0003")) {
            try {
                String[] attributes = line.split("\u0017", -1);
                int numAttributes = attributes.length;
                if (!includeFiles && numAttributes < expectedItemCount) {
                    LOG.debug("Wrong format. Skipping line " + line);
                    continue;
                }
                if (includeFiles && numAttributes < 7) {
                    LOG.debug("Wrong format for long template. Skipping line " + line);
                    continue;
                }
                String revisionString = attributes[0];
                String changeset = attributes[1];
                String parentsString = attributes[2];
                List<HgRevisionNumber> parents = HgLogCommand.parseParentRevisions(parentsString, revisionString);
                Date revisionDate = DATE_FORMAT.parse(attributes[3]);
                String author = attributes[4];
                String branchName = attributes[5];
                String commitMessage = attributes[6];
                HgRevisionNumber vcsRevisionNumber = new HgRevisionNumber(revisionString, changeset, author, commitMessage, parents);
                Set<String> filesAdded = Collections.emptySet();
                Set<String> filesModified = Collections.emptySet();
                Set<String> filesDeleted = Collections.emptySet();
                Map<String, String> copies = Collections.emptyMap();
                if (numAttributes > 7) {
                    filesAdded = HgLogCommand.parseFileList(attributes[7]);
                    if (numAttributes > 8) {
                        filesModified = HgLogCommand.parseFileList(attributes[8]);
                        if (numAttributes > 9) {
                            filesDeleted = HgLogCommand.parseFileList(attributes[9]);
                            if (numAttributes > 10) {
                                copies = shouldParseOldTemplate ? HgLogCommand.parseCopiesFileListAsOldVersion(attributes[10]) : HgLogCommand.parseCopiesFileList(attributes[10]);
                                Iterator<String> keys = copies.keySet().iterator();
                                while (keys.hasNext()) {
                                    String s = keys.next();
                                    if (filesAdded.contains(copies.get(s)) && filesDeleted.contains(s)) {
                                        filesAdded.remove(copies.get(s));
                                        filesDeleted.remove(s);
                                        continue;
                                    }
                                    if (filesDeleted.contains(s)) continue;
                                    keys.remove();
                                }
                            }
                        }
                    }
                }
                revisions.add(new HgFileRevision(this.myProject, hgFile, vcsRevisionNumber, branchName, revisionDate, author, commitMessage, filesModified, filesAdded, filesDeleted, copies));
            }
            catch (NumberFormatException e) {
                LOG.warn("Error parsing rev in line " + line);
            }
            catch (ParseException e) {
                LOG.warn("Error parsing date in line " + line);
            }
        }
        return revisions;
    }

    @Nullable
    public HgCommandResult execute(@NotNull VirtualFile repo, @NotNull String template, int limit, @Nullable HgFile hgFile, @Nullable List<String> argsForCmd) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgLogCommand", "execute"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgLogCommand", "execute"));
        }
        LinkedList<String> arguments = new LinkedList<String>();
        if (!(!this.myIncludeRemoved || this.myFollowCopies && this.myLogFile)) {
            arguments.add("--removed");
        }
        if (this.myFollowCopies) {
            arguments.add("--follow");
            if (!this.myLargeFilesWithFollowSupported) {
                arguments.add("--config");
                arguments.add("extensions.largefiles=!");
            }
        }
        arguments.add("--template");
        arguments.add(template);
        if (limit != -1) {
            arguments.add("--limit");
            arguments.add(String.valueOf(limit));
        }
        if (argsForCmd != null) {
            arguments.addAll(argsForCmd);
        }
        if (this.myLogFile && hgFile != null) {
            arguments.add(hgFile.getRelativePath());
        }
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setOutputAlwaysSuppressed(true);
        return commandExecutor.executeInCurrentThread(repo, "log", arguments);
    }

    private static Set<String> parseFileList(String fileListString) {
        if (StringUtil.isEmpty((String)fileListString)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(fileListString.split(" ")));
    }

    @NotNull
    public static Map<String, String> parseCopiesFileList(@Nullable String fileListString) {
        String[] filesList;
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseCopiesFileList"));
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        for (String pairOfFiles : filesList = fileListString.split("\u0001")) {
            String[] files = pairOfFiles.split("\\s+\\(");
            if (files.length != 2) {
                LOG.info("Couldn't parse copied files: " + fileListString);
                HashMap<String, String> hashMap = copies;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseCopiesFileList"));
                }
                return hashMap;
            }
            copies.put(files[1].substring(0, files[1].length() - 1), files[0]);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseCopiesFileList"));
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, String> parseCopiesFileListAsOldVersion(@Nullable String fileListString) {
        String source;
        int afterRightBraceIndex;
        if (StringUtil.isEmpty((String)fileListString)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseCopiesFileListAsOldVersion"));
            }
            return map;
        }
        HashMap<String, String> copies = new HashMap<String, String>();
        String[] filesList = fileListString.split("\\s+\\(");
        String target = filesList[0];
        for (int i = 1; i < filesList.length && (afterRightBraceIndex = HgLogCommand.findRightBracePosition(source = filesList[i])) != -1; ++i) {
            copies.put(source.substring(0, afterRightBraceIndex - 1), target);
            if (afterRightBraceIndex >= source.length()) break;
            target = source.substring(afterRightBraceIndex);
        }
        HashMap<String, String> hashMap = copies;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseCopiesFileListAsOldVersion"));
        }
        return hashMap;
    }

    private static int findRightBracePosition(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgLogCommand", "findRightBracePosition"));
        }
        int len = str.length();
        int depth = 1;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    --depth;
                }
            }
            if (depth != 0) continue;
            return i + 1;
        }
        LOG.info("Unexpected output during parse copied files in log command " + str);
        return -1;
    }

    @NotNull
    private static String[] constructTemplateArgument(boolean includeFiles, @NotNull HgVersion currentVersion) {
        if (currentVersion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgLogCommand", "constructTemplateArgument"));
        }
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("{rev}");
        templates.add("{node}");
        if (currentVersion.isParentRevisionTemplateSupported()) {
            templates.add("{p1rev}:{p1node} {p2rev}:{p2node}");
        } else {
            templates.add("{parents}");
        }
        templates.addAll(Arrays.asList("{date|isodatesec}", "{author}", "{branch}", "{desc}"));
        if (!includeFiles) {
            String[] stringArray = ArrayUtil.toStringArray(templates);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "constructTemplateArgument"));
            }
            return stringArray;
        }
        templates.addAll(Arrays.asList("{file_adds}", "{file_mods}", "{file_dels}"));
        templates.add(currentVersion.isBuiltInFunctionSupported() ? "{join(file_copies,'\u0001')}" : "{file_copies}");
        String[] stringArray = ArrayUtil.toStringArray(templates);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "constructTemplateArgument"));
        }
        return stringArray;
    }

    @NotNull
    private static List<HgRevisionNumber> parseParentRevisions(@NotNull String parentsString, @NotNull String currentRevisionString) {
        String[] parentStrings;
        if (parentsString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgLogCommand", "parseParentRevisions"));
        }
        if (currentRevisionString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgLogCommand", "parseParentRevisions"));
        }
        ArrayList<HgRevisionNumber> parents = new ArrayList<HgRevisionNumber>(2);
        if (StringUtil.isEmptyOrSpaces((String)parentsString)) {
            Long revision = Long.valueOf(currentRevisionString);
            HgRevisionNumber parentRevision = HgRevisionNumber.getLocalInstance(String.valueOf(revision - 1L));
            parents.add(parentRevision);
            ArrayList<HgRevisionNumber> arrayList = parents;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseParentRevisions"));
            }
            return arrayList;
        }
        for (String parentString : parentStrings = parentsString.trim().split(" ")) {
            String[] parentParts = parentString.split(":");
            if (Integer.valueOf(parentParts[0]) < 0) continue;
            parents.add(HgRevisionNumber.getInstance(parentParts[0], parentParts[1]));
        }
        ArrayList<HgRevisionNumber> arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgLogCommand", "parseParentRevisions"));
        }
        return arrayList;
    }
}

