/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgEncodingUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCommitCommand {
    private static final String TEMP_FILE_NAME = ".hg4idea-commit.tmp";
    private final Project myProject;
    private final VirtualFile myRoot;
    private final String myMessage;
    @NotNull
    private final Charset myCharset;
    private final boolean myAmend;
    private Set<HgFile> myFiles;

    public HgCommitCommand(Project project, @NotNull VirtualFile root, String message, boolean amend) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        this.myFiles = Collections.emptySet();
        this.myProject = project;
        this.myRoot = root;
        this.myMessage = message;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
        this.myAmend = amend;
    }

    public HgCommitCommand(Project project, @NotNull VirtualFile root, String message) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgCommitCommand", "<init>"));
        }
        this(project, root, message, false);
    }

    public void setFiles(@NotNull Set<HgFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgCommitCommand", "setFiles"));
        }
        this.myFiles = files;
    }

    public void execute() throws HgCommandException, VcsException {
        if (StringUtil.isEmptyOrSpaces((String)this.myMessage)) {
            throw new HgCommandException(HgVcsMessages.message("hg4idea.commit.error.messageEmpty", new Object[0]));
        }
        if (this.myFiles.isEmpty()) {
            this.commitChunkFiles(Collections.<String>emptyList(), this.myAmend);
        } else {
            List relativePaths = ContainerUtil.map2List(this.myFiles, (Function)new Function<HgFile, String>(){

                public String fun(HgFile file) {
                    return file.getRelativePath();
                }
            });
            List chunkedCommits = VcsFileUtil.chunkRelativePaths((List)relativePaths);
            int size = chunkedCommits.size();
            this.commitChunkFiles((List)chunkedCommits.get(0), this.myAmend);
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            boolean amendCommit = vcs != null && vcs.getVersion().isAmendSupported();
            for (int i = 1; i < size; ++i) {
                List chunk = (List)chunkedCommits.get(i);
                this.commitChunkFiles(chunk, amendCommit);
            }
        }
        if (!this.myProject.isDisposed()) {
            HgRepositoryManager manager = HgUtil.getRepositoryManager(this.myProject);
            manager.updateRepository(this.myRoot);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        ((HgUpdater)messageBus.syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
        ((HgUpdater)messageBus.syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.myProject, null);
    }

    private void commitChunkFiles(List<String> chunk, boolean amendCommit) throws VcsException {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("--logfile");
        parameters.add(this.saveCommitMessage().getAbsolutePath());
        parameters.addAll(chunk);
        if (amendCommit) {
            parameters.add("--amend");
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setCharset(this.myCharset);
        HgErrorHandler.ensureSuccess(executor.executeInCurrentThread(this.myRoot, "commit", parameters));
    }

    private File saveCommitMessage() throws VcsException {
        File systemDir = new File(PathManager.getSystemPath());
        File tempFile = new File(systemDir, TEMP_FILE_NAME);
        try {
            FileUtil.writeToFile((File)tempFile, (byte[])this.myMessage.getBytes(this.myCharset));
        }
        catch (IOException e) {
            throw new VcsException("Couldn't prepare commit message", (Throwable)e);
        }
        return tempFile;
    }
}

