/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;

public abstract class HgLogSingleCommitAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(HgLogSingleCommitAction.class);

    protected abstract void actionPerformed(@NotNull HgRepository var1, @NotNull VcsFullCommitDetails var2);

    public void actionPerformed(AnActionEvent e) {
        Data data = Data.collect(e);
        if (!data.isValid()) {
            return;
        }
        List details = data.log.getSelectedDetails();
        if (details.size() != 1) {
            return;
        }
        VcsFullCommitDetails commit = (VcsFullCommitDetails)details.get(0);
        HgRepositoryManager repositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)data.project, HgRepositoryManager.class));
        HgRepository repository = (HgRepository)repositoryManager.getRepositoryForRoot(commit.getRoot());
        if (repository == null) {
            DvcsUtil.noVcsRepositoryForRoot((Logger)LOG, (VirtualFile)commit.getRoot(), (Project)data.project, (RepositoryManager)repositoryManager, (AbstractVcs)HgVcs.getInstance(data.project));
            return;
        }
        this.actionPerformed(repository, commit);
    }

    public void update(AnActionEvent e) {
        Data data = Data.collect(e);
        boolean enabled = data.isValid() && data.log.getSelectedCommits().size() == 1;
        e.getPresentation().setVisible(data.isValid());
        e.getPresentation().setEnabled(enabled);
    }

    private static class Data {
        Project project;
        VcsLog log;

        private Data() {
        }

        static Data collect(AnActionEvent e) {
            Data data = new Data();
            data.project = (Project)e.getData(CommonDataKeys.PROJECT);
            data.log = (VcsLog)e.getData(VcsLogDataKeys.VSC_LOG);
            return data;
        }

        boolean isValid() {
            return this.project != null && this.log != null && DvcsUtil.logHasRootForVcs((VcsLog)this.log, (VcsKey)HgVcs.getKey());
        }
    }
}

