/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgBranchPopupActions;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopup {
    private final Project myProject;
    private final HgRepository myCurrentRepository;
    private final ListPopupImpl myPopup;

    public ListPopup asListPopup() {
        return this.myPopup;
    }

    public static HgBranchPopup getInstance(@NotNull Project project, @NotNull HgRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgBranchPopup", "getInstance"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgBranchPopup", "getInstance"));
        }
        return new HgBranchPopup(project, currentRepository);
    }

    private HgBranchPopup(@NotNull Project project, @NotNull HgRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgBranchPopup", "<init>"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgBranchPopup", "<init>"));
        }
        this.myProject = project;
        this.myCurrentRepository = currentRepository;
        String title = HgBranchPopup.createPopupTitle(currentRepository);
        Condition<AnAction> preselectActionCondition = new Condition<AnAction>(){

            public boolean value(AnAction action) {
                return false;
            }
        };
        this.myPopup = new BranchActionGroupPopup(title, project, (Condition)preselectActionCondition, this.createActions());
        this.setCurrentBranchInfo();
    }

    @NotNull
    private static String createPopupTitle(@NotNull HgRepository currentRepository) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgBranchPopup", "createPopupTitle"));
        }
        String title = "Hg Branches";
        String string = title = title + " in " + DvcsUtil.getShortRepositoryName((Repository)currentRepository);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgBranchPopup", "createPopupTitle"));
        }
        return string;
    }

    private void setCurrentBranchInfo() {
        String branchText = "Current branch : ";
        this.myPopup.setAdText(branchText + this.myCurrentRepository.getCurrentBranch(), 0);
    }

    private ActionGroup createActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
        popupGroup.addSeparator();
        return popupGroup;
    }

    @Nullable
    private DefaultActionGroup createRepositoriesActions() {
        List<VirtualFile> repositories = HgUtil.getHgRepositories(this.myProject);
        if (repositories.size() == 1) {
            return null;
        }
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addSeparator("Repositories");
        boolean isMultiRepoConfig = repositories.size() > 1;
        for (VirtualFile repository : repositories) {
            HgRepository repo = (HgRepository)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(repository);
            if (repo == null) continue;
            popupGroup.add((AnAction)new RootAction((Repository)repo, (Repository)(isMultiRepoConfig ? this.myCurrentRepository : null), new HgBranchPopupActions(repo.getProject(), repo).createActions(null), HgUtil.getDisplayableBranchOrBookmarkText(repo)));
        }
        return popupGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup popupGroup, @Nullable DefaultActionGroup actions) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgBranchPopup", "fillPopupWithCurrentRepositoryActions"));
        }
        popupGroup.addAll(new HgBranchPopupActions(this.myProject, this.myCurrentRepository).createActions(actions));
    }
}

