/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

abstract class HgAbstractGlobalAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)HgAbstractGlobalAction.class.getName());

    protected HgAbstractGlobalAction(Icon icon) {
        super(icon);
    }

    protected HgAbstractGlobalAction() {
    }

    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        HgRepository repo = file != null ? (HgRepository)repositoryManager.getRepositoryForFile(file) : HgUtil.getCurrentRepository(project);
        List repositories = repositoryManager.getRepositories();
        if (!repositories.isEmpty()) {
            this.execute(project, repositories, repo);
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
    }

    protected abstract void execute(@NotNull Project var1, @NotNull Collection<HgRepository> var2, @Nullable HgRepository var3);

    public static void handleException(@Nullable Project project, @NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgAbstractGlobalAction", "handleException"));
        }
        HgAbstractGlobalAction.handleException(project, "Error", e);
    }

    public static void handleException(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgAbstractGlobalAction", "handleException"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgAbstractGlobalAction", "handleException"));
        }
        LOG.info((Throwable)e);
        new HgCommandResultNotifier(project).notifyError(null, title, e.getMessage());
    }

    static void markDirtyAndHandleErrors(Project project, VirtualFile repository) {
        try {
            HgUtil.markDirectoryDirty(project, repository);
        }
        catch (InvocationTargetException e) {
            HgAbstractGlobalAction.handleException(project, e);
        }
        catch (InterruptedException e) {
            HgAbstractGlobalAction.handleException(project, e);
        }
    }

    public boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        HgVcs vcs = HgVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }

    @Nullable
    public static HgRepository getSelectedRepositoryFromEvent(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        return file != null ? (HgRepository)repositoryManager.getRepositoryForFile(file) : HgUtil.getCurrentRepository(project);
    }
}

