/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.client.SimpleProtobufClient;
import org.jetbrains.jps.client.UUIDGetter;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.JavacServerResponseHandler;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavacServerClient
extends SimpleProtobufClient<JavacServerResponseHandler> {
    public JavacServerClient() {
        super((MessageLite)JavacRemoteProto.Message.getDefaultInstance(), (Executor)SharedThreadPool.getInstance(), new UUIDGetter(){

            @Override
            @NotNull
            public UUID getSessionUUID(@NotNull JavacRemoteProto.Message message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/javac/JavacServerClient$1", "getSessionUUID"));
                }
                JavacRemoteProto.Message.UUID uuid = message.getSessionId();
                UUID uUID = new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits());
                if (uUID == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/JavacServerClient$1", "getSessionUUID"));
                }
                return uUID;
            }
        });
    }

    public RequestFuture<JavacServerResponseHandler> sendCompileRequest(List<String> options, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> sourcePath, Map<File, Set<File>> outs, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink) {
        JavacServerResponseHandler rh = new JavacServerResponseHandler(diagnosticSink, outputSink, JavacServerClient.getEncodingName(options));
        JavacRemoteProto.Message.Request request = JavacProtoUtil.createCompilationRequest(options, files, classpath, platformCp, sourcePath, outs);
        return this.sendRequest(request, rh, new RequestFuture.CancelAction<JavacServerResponseHandler>(){

            @Override
            public void cancel(RequestFuture<JavacServerResponseHandler> javacServerResponseHandlerRequestFuture) throws Exception {
                JavacServerClient.this.sendRequest(JavacProtoUtil.createCancelRequest(), null, null);
            }
        });
    }

    public RequestFuture sendShutdownRequest() {
        return this.sendRequest(JavacProtoUtil.createShutdownRequest(), null, null);
    }

    private RequestFuture<JavacServerResponseHandler> sendRequest(JavacRemoteProto.Message.Request request, JavacServerResponseHandler responseHandler, RequestFuture.CancelAction<JavacServerResponseHandler> cancelAction) {
        UUID requestId = UUID.randomUUID();
        return this.sendMessage(requestId, (MessageLite)JavacProtoUtil.toMessage(requestId, request), responseHandler, cancelAction);
    }

    @Nullable
    private static String getEncodingName(List<String> options) {
        boolean found = false;
        for (String option : options) {
            if (found) {
                return option;
            }
            if (!"-encoding".equalsIgnoreCase(option)) continue;
            found = true;
        }
        return null;
    }
}

