/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.javac.JavacServer;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavacServerBootstrap {
    public static BaseOSProcessHandler launchJavacServer(String sdkHomePath, int heapSize, int port, File workingDir, List<String> vmOptions, JavaCompilingTool compilingTool) throws Exception {
        String region;
        String country;
        String lang;
        ArrayList<String> cmdLine = new ArrayList<String>();
        JavacServerBootstrap.appendParam(cmdLine, JavacServerBootstrap.getVMExecutablePath(sdkHomePath));
        JavacServerBootstrap.appendParam(cmdLine, "-XX:MaxPermSize=150m");
        JavacServerBootstrap.appendParam(cmdLine, "-Djava.awt.headless=true");
        int xms = heapSize / 2;
        if (xms > 32) {
            JavacServerBootstrap.appendParam(cmdLine, "-Xms" + xms + "m");
        }
        JavacServerBootstrap.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        String encoding = System.getProperty("file.encoding");
        if (encoding != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Dfile.encoding=" + encoding);
        }
        if ((lang = System.getProperty("user.language")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.language=" + lang);
        }
        if ((country = System.getProperty("user.country")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.country=" + country);
        }
        if ((region = System.getProperty("user.region")) != null) {
            JavacServerBootstrap.appendParam(cmdLine, "-Duser.region=" + region);
        }
        JavacServerBootstrap.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        JavacServerBootstrap.appendParam(cmdLine, "-Djava.ext.dirs=");
        for (String option : vmOptions) {
            JavacServerBootstrap.appendParam(cmdLine, option);
        }
        JavacServerBootstrap.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getJavacServerClasspath(sdkHomePath, compilingTool);
        StringBuilder classpath = new StringBuilder();
        for (File file : cp) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(file.getPath());
        }
        JavacServerBootstrap.appendParam(cmdLine, classpath.toString());
        JavacServerBootstrap.appendParam(cmdLine, JavacServer.class.getName());
        JavacServerBootstrap.appendParam(cmdLine, Integer.toString(port));
        workingDir.mkdirs();
        JavacServerBootstrap.appendParam(cmdLine, FileUtil.toSystemIndependentName((String)workingDir.getPath()));
        ProcessBuilder builder = new ProcessBuilder(cmdLine);
        builder.directory(workingDir);
        Process process = builder.start();
        BaseOSProcessHandler processHandler = new BaseOSProcessHandler(process, null, null){

            protected Future<?> executeOnPooledThread(Runnable task) {
                return SharedThreadPool.getInstance().executeOnPooledThread(task);
            }
        };
        JavacServerBootstrap.configureProcessHandler(processHandler);
        return processHandler;
    }

    private static void configureProcessHandler(final BaseOSProcessHandler processHandler) throws Exception {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        System.out.print("JAVAC_SERVER: " + text);
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        System.err.print("JAVAC_SERVER: " + text);
                    }
                }
            }
        });
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref serverStartMessage = new Ref(null);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(ProcessEvent event) {
                try {
                    processHandler.removeProcessListener((ProcessListener)this);
                }
                finally {
                    semaphore.up();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text;
                if (outputType == ProcessOutputTypes.STDERR && (text = event.getText()) != null && (text.contains("Javac server started successfully. Listening on port: ") || text.contains("Error starting Javac Server: "))) {
                    try {
                        processHandler.removeProcessListener((ProcessListener)this);
                        serverStartMessage.set((Object)text);
                    }
                    finally {
                        semaphore.up();
                    }
                }
            }
        });
        processHandler.startNotify();
        semaphore.waitFor();
        String startupMsg = (String)serverStartMessage.get();
        if (startupMsg == null || !startupMsg.contains("Javac server started successfully. Listening on port: ")) {
            throw new Exception("Server startup failed: " + startupMsg);
        }
    }

    private static void appendParam(List<String> cmdLine, String param) {
        if (SystemInfo.isWindows) {
            if (param.contains("\"")) {
                param = StringUtil.replace((String)param, (String)"\"", (String)"\\\"");
            } else if (param.length() == 0) {
                param = "\"\"";
            }
        }
        cmdLine.add(param);
    }

    public static String getVMExecutablePath(String sdkHome) {
        return sdkHome + "/bin/java";
    }
}

