/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.service.SharedThreadPool;

public class JavacServer {
    public static final int DEFAULT_SERVER_PORT = 7878;
    public static final String SERVER_SUCCESS_START_MESSAGE = "Javac server started successfully. Listening on port: ";
    public static final String SERVER_ERROR_START_MESSAGE = "Error starting Javac Server: ";
    public static final String JPS_JAVA_COMPILING_TOOL_PROPERTY = "jps.java.compiling.tool";
    private ChannelRegistrar myChannelRegistrar;
    private final Set<CancelHandler> myCancelHandlers = Collections.synchronizedSet(new HashSet());

    public void start(int listenPort) {
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, (Executor)SharedThreadPool.getInstance())).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.myChannelRegistrar = new ChannelRegistrar();
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{JavacServer.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        this.myChannelRegistrar.add(bootstrap.bind(listenPort).syncUninterruptibly().channel());
    }

    public void stop() {
        this.myChannelRegistrar.close().awaitUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JavacServer server = null;
        try {
            int port = 7878;
            if (args.length > 0) {
                try {
                    port = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error parsing port: " + e.getMessage());
                    System.exit(-1);
                }
            }
            server = new JavacServer();
            server.start(port);
            final JavacServer finalServer = server;
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook thread"){

                @Override
                public void run() {
                    finalServer.stop();
                }
            });
            System.out.println("Server classpath: " + System.getProperty("java.class.path"));
            System.err.println(SERVER_SUCCESS_START_MESSAGE + port);
        }
        catch (Throwable e) {
            System.err.println(SERVER_ERROR_START_MESSAGE + e.getMessage());
            e.printStackTrace(System.err);
            try {
                if (server != null) {
                    server.stop();
                }
            }
            finally {
                System.exit(-1);
            }
        }
    }

    public static JavacRemoteProto.Message compile(final ChannelHandlerContext context, final UUID sessionId, List<String> options, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> sourcePath, Map<File, Set<File>> outs, CanceledStatus canceledStatus) {
        DiagnosticOutputConsumer diagnostic = new DiagnosticOutputConsumer(){

            @Override
            public void javaFileLoaded(File file) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createSourceFileLoadedResponse(file)));
            }

            @Override
            public void outputLineAvailable(String line) {
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createStdOutputResponse(line)));
            }

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createBuildMessageResponse(diagnostic);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }

            @Override
            public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
                JavacRemoteProto.Message.Response response = JavacProtoUtil.createClassDataResponse(className, imports, staticImports);
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, response));
            }
        };
        OutputFileConsumer outputSink = new OutputFileConsumer(){

            @Override
            public void save(@NotNull OutputFileObject fileObject) {
                if (fileObject == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/javac/JavacServer$4", "save"));
                }
                context.channel().writeAndFlush((Object)JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createOutputObjectResponse(fileObject)));
            }
        };
        try {
            JavaCompilingTool tool = JavacServer.getCompilingTool();
            boolean rc = JavacMain.compile(options, files, classpath, platformCp, sourcePath, outs, diagnostic, outputSink, canceledStatus, tool);
            return JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createBuildCompletedResponse(rc));
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure(e.getMessage(), e));
        }
    }

    private static JavaCompilingTool getCompilingTool() {
        JavaCompilingTool tool;
        String property = System.getProperty(JPS_JAVA_COMPILING_TOOL_PROPERTY);
        if (property != null && (tool = JavaBuilderUtil.findCompilingTool(property)) != null) {
            return tool;
        }
        return new JavacCompilerTool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuilds() {
        Set<CancelHandler> set = this.myCancelHandlers;
        synchronized (set) {
            for (CancelHandler handler : this.myCancelHandlers) {
                handler.cancel();
            }
        }
    }

    private static List<File> toFiles(List<String> paths) {
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (String path : paths) {
            files.add(new File(path));
        }
        return files;
    }

    private static class CancelHandler
    implements CanceledStatus {
        private volatile boolean myIsCanceled = false;

        private CancelHandler() {
        }

        public void cancel() {
            this.myIsCanceled = true;
        }

        @Override
        public boolean isCanceled() {
            return this.myIsCanceled;
        }
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/javac/JavacServer$ChannelRegistrar", "add"));
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            ChannelGroupFuture future;
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                future = this.openChannels.close();
            }
            finally {
                assert (eventLoopGroup != null);
                eventLoopGroup.shutdownGracefully();
            }
            return future;
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(final ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            final UUID sessionId = JavacProtoUtil.fromProtoUUID(message.getSessionId());
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.REQUEST) {
                    JavacRemoteProto.Message.Request request = message.getRequest();
                    JavacRemoteProto.Message.Request.Type requestType = request.getRequestType();
                    if (requestType == JavacRemoteProto.Message.Request.Type.COMPILE) {
                        final List<String> options = request.getOptionList();
                        final List files = JavacServer.toFiles(request.getFileList());
                        final List cp = JavacServer.toFiles(request.getClasspathList());
                        final List platformCp = JavacServer.toFiles(request.getPlatformClasspathList());
                        final List srcPath = JavacServer.toFiles(request.getSourcepathList());
                        final HashMap outs = new HashMap();
                        for (JavacRemoteProto.Message.Request.OutputGroup outputGroup : request.getOutputList()) {
                            HashSet<File> srcRoots = new HashSet<File>();
                            for (String root : outputGroup.getSourceRootList()) {
                                srcRoots.add(new File(root));
                            }
                            outs.put(new File(outputGroup.getOutputRoot()), srcRoots);
                        }
                        final CancelHandler cancelHandler = new CancelHandler();
                        JavacServer.this.myCancelHandlers.add(cancelHandler);
                        SharedThreadPool.getInstance().executeOnPooledThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    context.channel().writeAndFlush((Object)JavacServer.compile(context, sessionId, options, files, cp, platformCp, srcPath, outs, cancelHandler));
                                }
                                finally {
                                    JavacServer.this.myCancelHandlers.remove(cancelHandler);
                                }
                            }
                        });
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.CANCEL) {
                        JavacServer.this.cancelBuilds();
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createRequestAckResponse());
                    } else if (requestType == JavacRemoteProto.Message.Request.Type.SHUTDOWN) {
                        JavacServer.this.cancelBuilds();
                        new Thread("StopThread"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    JavacServer.this.stop();
                                }
                                finally {
                                    System.exit(0);
                                }
                            }
                        }.start();
                    } else {
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported request type: " + requestType.name(), null));
                    }
                } else {
                    reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported message: " + messageType.name(), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }
}

