/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class FileKeyDescriptor
implements KeyDescriptor<File> {
    private final byte[] buffer = IOUtil.allocReadWriteUTFBuffer();

    public void save(@NotNull DataOutput out, File value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/FileKeyDescriptor", "save"));
        }
        IOUtil.writeUTFFast((byte[])this.buffer, (DataOutput)out, (String)value.getPath());
    }

    public File read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/FileKeyDescriptor", "read"));
        }
        return new File(IOUtil.readUTFFast((byte[])this.buffer, (DataInput)in));
    }

    public int getHashCode(File value) {
        return FileUtil.fileHashCode((File)value);
    }

    public boolean isEqual(File val1, File val2) {
        return FileUtil.filesEqual((File)val1, (File)val2);
    }
}

