/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.IOUtil;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.storage.Timestamps;
import org.jetbrains.jps.model.JpsModel;

public class FSState {
    public static final int VERSION = 3;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.FSState");
    private final Map<BuildTarget<?>, FilesDelta> myDeltas = Collections.synchronizedMap(new HashMap());
    private final Set<BuildTarget<?>> myInitialScanPerformed = Collections.synchronizedSet(new HashSet());
    private final TObjectLongHashMap<File> myRegistrationStamps = new TObjectLongHashMap(FileUtil.FILE_HASHING_STRATEGY);

    public void save(DataOutput out) throws IOException {
        MultiMap targetsByType = new MultiMap();
        for (BuildTarget<?> target : this.myInitialScanPerformed) {
            targetsByType.putValue(target.getTargetType(), target);
        }
        out.writeInt(targetsByType.size());
        for (BuildTargetType type : targetsByType.keySet()) {
            IOUtil.writeString((String)type.getTypeId(), (DataOutput)out);
            Collection targets = targetsByType.get((Object)type);
            out.writeInt(targets.size());
            for (BuildTarget target : targets) {
                IOUtil.writeString((String)target.getId(), (DataOutput)out);
                this.getDelta(target).save(out);
            }
        }
    }

    public void load(DataInputStream in, JpsModel model, BuildRootIndex buildRootIndex) throws IOException {
        TargetTypeRegistry registry = TargetTypeRegistry.getInstance();
        int typeCount = in.readInt();
        while (typeCount-- > 0) {
            BuildTargetLoader<?> loader;
            String typeId = IOUtil.readString((DataInput)in);
            int targetCount = in.readInt();
            BuildTargetType<?> type = registry.getTargetType(typeId);
            BuildTargetLoader<?> buildTargetLoader = loader = type != null ? type.createLoader(model) : null;
            while (targetCount-- > 0) {
                Object target;
                String id = IOUtil.readString((DataInput)in);
                boolean loaded = false;
                if (loader != null && (target = loader.createTarget(id)) != null) {
                    this.getDelta((BuildTarget<?>)target).load(in, (BuildTarget<?>)target, buildRootIndex);
                    this.myInitialScanPerformed.add((BuildTarget<?>)target);
                    loaded = true;
                }
                if (loaded) continue;
                LOG.info("Skipping unknown target (typeId=" + typeId + ", type=" + type + ", id=" + id + ")");
                FilesDelta.skip(in);
            }
        }
    }

    public void clearAll() {
        this.myInitialScanPerformed.clear();
        this.myDeltas.clear();
        this.myRegistrationStamps.clear();
    }

    public final void clearRecompile(BuildRootDescriptor rd) {
        this.getDelta(rd.getTarget()).clearRecompile(rd);
    }

    public boolean markDirty(@Nullable CompileContext context, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        boolean marked = this.getDelta(rd.getTarget()).markRecompile(rd, file);
        if (marked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(rd.getTarget() + ": MARKED DIRTY: " + file.getPath());
            }
            if (saveEventStamp) {
                this.myRegistrationStamps.put((Object)file, System.currentTimeMillis());
            }
            if (tsStorage != null) {
                tsStorage.removeStamp(file, rd.getTarget());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(rd.getTarget() + ": NOT MARKED DIRTY: " + file.getPath());
        }
        return marked;
    }

    public long getEventRegistrationStamp(File file) {
        return this.myRegistrationStamps.get((Object)file);
    }

    public boolean markDirtyIfNotDeleted(@Nullable CompileContext context, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage) throws IOException {
        boolean marked = this.getDelta(rd.getTarget()).markRecompileIfNotDeleted(rd, file);
        if (marked && tsStorage != null) {
            tsStorage.removeStamp(file, rd.getTarget());
        }
        return marked;
    }

    public void registerDeleted(BuildTarget<?> target, File file, @Nullable Timestamps tsStorage) throws IOException {
        this.registerDeleted(target, file);
        if (tsStorage != null) {
            tsStorage.removeStamp(file, target);
        }
    }

    public void registerDeleted(BuildTarget<?> target, File file) {
        this.getDelta(target).addDeleted(file);
    }

    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile(@NotNull CompileContext context, BuildTarget<?> target) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/FSState", "getSourcesToRecompile"));
        }
        return this.getDelta(target).getSourcesToRecompile();
    }

    public void clearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            delta.clearDeletedPaths();
        }
    }

    public Collection<String> getAndClearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            return delta.getAndClearDeletedPaths();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final FilesDelta getDelta(BuildTarget<?> buildTarget) {
        Map<BuildTarget<?>, FilesDelta> map = this.myDeltas;
        // MONITORENTER : map
        FilesDelta delta = this.myDeltas.get(buildTarget);
        if (delta == null) {
            delta = new FilesDelta();
            this.myDeltas.put(buildTarget, delta);
        }
        FilesDelta filesDelta = delta;
        // MONITOREXIT : map
        if (filesDelta != null) return filesDelta;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/fs/FSState", "getDelta"));
    }

    public boolean hasWorkToDo(BuildTarget<?> target) {
        if (!this.myInitialScanPerformed.contains(target)) {
            return true;
        }
        FilesDelta delta = this.myDeltas.get(target);
        return delta != null && delta.hasChanges();
    }

    public void markInitialScanPerformed(BuildTarget<?> target) {
        this.myInitialScanPerformed.add(target);
    }

    public boolean isInitialScanPerformed(BuildTarget<?> target) {
        return this.myInitialScanPerformed.contains(target);
    }
}

