/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileSystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.FSState;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.storage.Timestamps;

public class BuildFSState
extends FSState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.BuildFSState");
    private static final Key<Set<? extends BuildTarget<?>>> CONTEXT_TARGETS_KEY = Key.create((String)"_fssfate_context_targets_");
    private static final Key<FilesDelta> CURRENT_ROUND_DELTA_KEY = Key.create((String)"_current_round_delta_");
    private static final Key<FilesDelta> LAST_ROUND_DELTA_KEY = Key.create((String)"_last_round_delta_");
    private final boolean myAlwaysScanFS;

    public BuildFSState(boolean alwaysScanFS) {
        this.myAlwaysScanFS = alwaysScanFS;
    }

    @Override
    public boolean isInitialScanPerformed(BuildTarget<?> target) {
        return !this.myAlwaysScanFS && super.isInitialScanPerformed(target);
    }

    @Override
    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile(@NotNull CompileContext context, BuildTarget<?> target) {
        FilesDelta lastRoundDelta;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/BuildFSState", "getSourcesToRecompile"));
        }
        if (target instanceof ModuleBuildTarget && (lastRoundDelta = BuildFSState.getRoundDelta(LAST_ROUND_DELTA_KEY, context)) != null) {
            return lastRoundDelta.getSourcesToRecompile();
        }
        return super.getSourcesToRecompile(context, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMarkedForRecompilation(@Nullable CompileContext context, BuildRootDescriptor rd, File file) {
        Map<BuildRootDescriptor, Set<File>> recompile;
        FilesDelta delta = BuildFSState.getRoundDelta(LAST_ROUND_DELTA_KEY, context);
        if (delta == null) {
            delta = this.getDelta(rd.getTarget());
        }
        Map<BuildRootDescriptor, Set<File>> map = recompile = delta.getSourcesToRecompile();
        synchronized (map) {
            Set<File> files = recompile.get(rd);
            return files != null && files.contains(file);
        }
    }

    @Override
    public boolean markDirty(@Nullable CompileContext context, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        FilesDelta roundDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context);
        if (roundDelta != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        return super.markDirty(context, file, rd, tsStorage, saveEventStamp);
    }

    private static boolean isInCurrentContextTargets(CompileContext context, BuildRootDescriptor rd) {
        if (context == null) {
            return false;
        }
        Set targets = (Set)CONTEXT_TARGETS_KEY.get((UserDataHolder)context, Collections.emptySet());
        return targets.contains(rd.getTarget());
    }

    @Override
    public boolean markDirtyIfNotDeleted(@Nullable CompileContext context, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage) throws IOException {
        FilesDelta roundDelta;
        boolean marked = super.markDirtyIfNotDeleted(context, file, rd, tsStorage);
        if (marked && (roundDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context)) != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        return marked;
    }

    @Override
    public void clearAll() {
        this.clearContextRoundData(null);
        this.clearContextChunk(null);
        super.clearAll();
    }

    public void clearContextRoundData(@Nullable CompileContext context) {
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, null);
        BuildFSState.setRoundDelta(LAST_ROUND_DELTA_KEY, context, null);
    }

    public void clearContextChunk(@Nullable CompileContext context) {
        BuildFSState.setContextTargets(context, null);
    }

    public void beforeChunkBuildStart(@NotNull CompileContext context, BuildTargetChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/BuildFSState", "beforeChunkBuildStart"));
        }
        BuildFSState.setContextTargets(context, chunk.getTargets());
    }

    public void beforeNextRoundStart(@NotNull CompileContext context, ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/BuildFSState", "beforeNextRoundStart"));
        }
        BuildFSState.setRoundDelta(LAST_ROUND_DELTA_KEY, context, BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context));
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, new FilesDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BuildRootDescriptor, T extends BuildTarget<R>> boolean processFilesToRecompile(CompileContext context, T target, FileProcessor<R, T> processor) throws IOException {
        Map<BuildRootDescriptor, Set<File>> data = this.getSourcesToRecompile(context, target);
        CompileScope scope = context.getScope();
        Map<BuildRootDescriptor, Set<File>> map = data;
        synchronized (map) {
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : data.entrySet()) {
                BuildRootDescriptor root = entry.getKey();
                for (File file : entry.getValue()) {
                    if (!scope.isAffected(target, file) || processor.apply(target, file, root)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean markAllUpToDate(CompileContext context, BuildRootDescriptor rd, Timestamps stamps) throws IOException {
        boolean marked = false;
        FilesDelta delta = this.getDelta(rd.getTarget());
        Set<File> files = delta.clearRecompile(rd);
        if (files != null) {
            CompileScope scope = context.getScope();
            long compilationStartStamp = context.getCompilationStartStamp();
            for (File file : files) {
                if (scope.isAffected(rd.getTarget(), file)) {
                    long currentFileStamp = FileSystemUtil.lastModified((File)file);
                    if (!(rd.isGenerated() || currentFileStamp <= compilationStartStamp && this.getEventRegistrationStamp(file) <= compilationStartStamp)) {
                        if (Utils.IS_TEST_MODE) {
                            LOG.info("Timestamp after compilation started; marking dirty again: " + file.getPath());
                        }
                        delta.markRecompile(rd, file);
                        continue;
                    }
                    marked = true;
                    stamps.saveStamp(file, rd.getTarget(), currentFileStamp);
                    continue;
                }
                if (Utils.IS_TEST_MODE) {
                    LOG.info("Not affected by compile scope; marking dirty again: " + file.getPath());
                }
                delta.markRecompile(rd, file);
            }
        }
        return marked;
    }

    private static void setContextTargets(@Nullable CompileContext context, @Nullable Set<? extends BuildTarget<?>> targets) {
        if (context != null) {
            CONTEXT_TARGETS_KEY.set((UserDataHolder)context, targets);
        }
    }

    @Nullable
    private static FilesDelta getRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/BuildFSState", "getRoundDelta"));
        }
        return context != null ? (FilesDelta)key.get((UserDataHolder)context) : null;
    }

    private static void setRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context, @Nullable FilesDelta delta) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/fs/BuildFSState", "setRoundDelta"));
        }
        if (context != null) {
            key.set((UserDataHolder)context, (Object)delta);
        }
    }
}

