/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;

public class JarInfo {
    private final List<Pair<String, Object>> myContent;
    private final DestinationInfo myDestination;

    public JarInfo(@NotNull DestinationInfo destination) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/JarInfo", "<init>"));
        }
        this.myDestination = destination;
        this.myContent = new ArrayList<Pair<String, Object>>();
    }

    public void addContent(String pathInJar, ArtifactRootDescriptor descriptor) {
        this.myContent.add((Pair<String, Object>)Pair.create((Object)pathInJar, (Object)descriptor));
    }

    public void addJar(String pathInJar, JarInfo jarInfo) {
        this.myContent.add((Pair<String, Object>)Pair.create((Object)pathInJar, (Object)jarInfo));
    }

    public List<Pair<String, Object>> getContent() {
        return this.myContent;
    }

    public DestinationInfo getDestination() {
        return this.myDestination;
    }

    public String getPresentableDestination() {
        return this.myDestination.getOutputPath();
    }
}

