/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.builders;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ClassMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.artifacts.builders.ArtifactLayoutCustomizationService;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuilderService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.incremental.artifacts.instructions.CopyToDirectoryInstructionCreator;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsComplexPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public class LayoutElementBuildersRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuildersRegistry");
    private ClassMap<LayoutElementBuilderService> myBuilders = new ClassMap();

    public static LayoutElementBuildersRegistry getInstance() {
        return InstanceHolder.ourInstance;
    }

    private LayoutElementBuildersRegistry() {
        LayoutElementBuilderService[] standardBuilders;
        for (LayoutElementBuilderService builder : standardBuilders = new LayoutElementBuilderService[]{new RootElementBuilder(), new DirectoryElementBuilder(), new ArchiveElementBuilder(), new DirectoryCopyElementBuilder(), new FileCopyElementBuilder(), new ExtractedDirectoryElementBuilder(), new ModuleOutputElementBuilder(), new ModuleTestOutputElementBuilder(), new ComplexElementBuilder(), new ArtifactOutputElementBuilder()}) {
            this.myBuilders.put(builder.getElementClass(), (Object)builder);
        }
        for (LayoutElementBuilderService builder : JpsServiceManager.getInstance().getExtensions(LayoutElementBuilderService.class)) {
            this.myBuilders.put(builder.getElementClass(), (Object)builder);
        }
    }

    public void generateInstructions(JpsArtifact artifact, CopyToDirectoryInstructionCreator creator, ArtifactInstructionsBuilderContext context) {
        context.enterArtifact(artifact);
        this.generateInstructions((JpsPackagingElement)artifact.getRootElement(), (ArtifactCompilerInstructionCreator)creator, context);
    }

    public Collection<BuildTarget<?>> getDependencies(JpsPackagingElement element, TargetOutputIndex outputIndex) {
        LayoutElementBuilderService<?> builder = this.getElementBuilder(element);
        if (builder != null) {
            return builder.getDependencies(element, outputIndex);
        }
        return Collections.emptyList();
    }

    private void generateInstructions(JpsPackagingElement layoutElement, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        LayoutElementBuilderService<?> builder = this.getElementBuilder(layoutElement);
        if (builder != null) {
            builder.generateInstructions(layoutElement, instructionCreator, builderContext);
        }
    }

    private LayoutElementBuilderService<?> getElementBuilder(JpsPackagingElement layoutElement) {
        LayoutElementBuilderService builder = (LayoutElementBuilderService)this.myBuilders.get(layoutElement.getClass());
        if (builder == null) {
            LOG.error("Builder not found for artifact output layout element of class " + layoutElement.getClass());
        }
        return builder;
    }

    private void generateChildrenInstructions(JpsCompositePackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        this.generateInstructions(element.getChildren(), instructionCreator, builderContext);
    }

    private void generateSubstitutionInstructions(JpsComplexPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        List substitution = element.getSubstitution();
        if (substitution != null) {
            this.generateInstructions(substitution, instructionCreator, builderContext);
        }
    }

    private void generateInstructions(List<JpsPackagingElement> elements, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        for (JpsPackagingElement child : elements) {
            this.generateInstructions(child, instructionCreator, builderContext);
        }
    }

    private static void generateModuleOutputInstructions(@Nullable String outputUrl, ArtifactCompilerInstructionCreator creator) {
        if (outputUrl != null) {
            creator.addDirectoryCopyInstructions(JpsPathUtil.urlToFile((String)outputUrl));
        }
    }

    private class ArtifactOutputElementBuilder
    extends LayoutElementBuilderService<JpsArtifactOutputPackagingElement> {
        public ArtifactOutputElementBuilder() {
            super(JpsArtifactOutputPackagingElement.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generateInstructions(JpsArtifactOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            JpsArtifact artifact = (JpsArtifact)element.getArtifactReference().resolve();
            if (artifact == null) {
                return;
            }
            Set<JpsArtifact> parentArtifacts = builderContext.getParentArtifacts();
            List<JpsPackagingElement> customLayout = this.getCustomArtifactLayout(artifact, parentArtifacts);
            String outputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)outputPath) || customLayout != null) {
                try {
                    if (builderContext.enterArtifact(artifact)) {
                        if (customLayout != null) {
                            LayoutElementBuildersRegistry.this.generateInstructions(customLayout, instructionCreator, builderContext);
                        } else {
                            LayoutElementBuildersRegistry.this.generateSubstitutionInstructions((JpsComplexPackagingElement)element, instructionCreator, builderContext);
                        }
                    }
                }
                finally {
                    builderContext.leaveArtifact(artifact);
                }
                return;
            }
            JpsCompositePackagingElement rootElement = artifact.getRootElement();
            File outputDir = new File(outputPath);
            if (rootElement instanceof JpsArchivePackagingElement) {
                String fileName = ((JpsArchivePackagingElement)rootElement).getArchiveName();
                instructionCreator.addFileCopyInstruction(new File(outputDir, fileName), fileName);
            } else {
                instructionCreator.addDirectoryCopyInstructions(outputDir);
            }
        }

        @Nullable
        private List<JpsPackagingElement> getCustomArtifactLayout(@NotNull JpsArtifact artifact, @NotNull Set<JpsArtifact> parentArtifacts) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ArtifactOutputElementBuilder", "getCustomArtifactLayout"));
            }
            if (parentArtifacts == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ArtifactOutputElementBuilder", "getCustomArtifactLayout"));
            }
            for (ArtifactLayoutCustomizationService service : JpsServiceManager.getInstance().getExtensions(ArtifactLayoutCustomizationService.class)) {
                List<JpsPackagingElement> elements = service.getCustomizedLayout(artifact, parentArtifacts);
                if (elements == null) continue;
                return elements;
            }
            return null;
        }
    }

    private class ComplexElementBuilder
    extends LayoutElementBuilderService<JpsComplexPackagingElement> {
        public ComplexElementBuilder() {
            super(JpsComplexPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsComplexPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateSubstitutionInstructions(element, instructionCreator, builderContext);
        }
    }

    private static class ModuleTestOutputElementBuilder
    extends LayoutElementBuilderService<JpsTestModuleOutputPackagingElement> {
        public ModuleTestOutputElementBuilder() {
            super(JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsTestModuleOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.generateModuleOutputInstructions(element.getOutputUrl(), instructionCreator);
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsTestModuleOutputPackagingElement element, TargetOutputIndex outputIndex) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ModuleTestOutputElementBuilder", "getDependencies"));
            }
            JpsModule module = (JpsModule)element.getModuleReference().resolve();
            if (module != null) {
                return Collections.singletonList(new ModuleBuildTarget(module, JavaModuleBuildTargetType.TEST));
            }
            return Collections.emptyList();
        }
    }

    private static class ModuleOutputElementBuilder
    extends LayoutElementBuilderService<JpsProductionModuleOutputPackagingElement> {
        public ModuleOutputElementBuilder() {
            super(JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsProductionModuleOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.generateModuleOutputInstructions(element.getOutputUrl(), instructionCreator);
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsProductionModuleOutputPackagingElement element, TargetOutputIndex outputIndex) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$ModuleOutputElementBuilder", "getDependencies"));
            }
            JpsModule module = (JpsModule)element.getModuleReference().resolve();
            if (module != null) {
                return Collections.singletonList(new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
            }
            return Collections.emptyList();
        }
    }

    private static class ExtractedDirectoryElementBuilder
    extends LayoutElementBuilderService<JpsExtractedDirectoryPackagingElement> {
        public ExtractedDirectoryElementBuilder() {
            super(JpsExtractedDirectoryPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsExtractedDirectoryPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String jarPath = element.getFilePath();
            String pathInJar = element.getPathInJar();
            instructionCreator.addExtractDirectoryInstruction(new File(jarPath), pathInJar);
        }
    }

    private static class FileCopyElementBuilder
    extends LayoutElementBuilderService<JpsFileCopyPackagingElement> {
        public FileCopyElementBuilder() {
            super(JpsFileCopyPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsFileCopyPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String filePath = element.getFilePath();
            if (filePath != null) {
                File file = new File(filePath);
                String fileName = element.getRenamedOutputFileName();
                instructionCreator.addFileCopyInstruction(file, fileName != null ? fileName : file.getName());
            }
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsFileCopyPackagingElement element, TargetOutputIndex outputIndex) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$FileCopyElementBuilder", "getDependencies"));
            }
            String filePath = element.getFilePath();
            if (filePath != null) {
                return outputIndex.getTargetsByOutputFile(new File(filePath));
            }
            return Collections.emptyList();
        }
    }

    private static class DirectoryCopyElementBuilder
    extends LayoutElementBuilderService<JpsDirectoryCopyPackagingElement> {
        public DirectoryCopyElementBuilder() {
            super(JpsDirectoryCopyPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsDirectoryCopyPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            String dirPath = element.getDirectoryPath();
            if (dirPath != null) {
                File directory = new File(dirPath);
                instructionCreator.addDirectoryCopyInstructions(directory);
            }
        }

        @Override
        public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsDirectoryCopyPackagingElement element, TargetOutputIndex outputIndex) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/builders/LayoutElementBuildersRegistry$DirectoryCopyElementBuilder", "getDependencies"));
            }
            String dirPath = element.getDirectoryPath();
            if (dirPath != null) {
                return outputIndex.getTargetsByOutputFile(new File(dirPath));
            }
            return Collections.emptyList();
        }
    }

    private class ArchiveElementBuilder
    extends LayoutElementBuilderService<JpsArchivePackagingElement> {
        public ArchiveElementBuilder() {
            super(JpsArchivePackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsArchivePackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator.archive(element.getArchiveName()), builderContext);
        }
    }

    private class DirectoryElementBuilder
    extends LayoutElementBuilderService<JpsDirectoryPackagingElement> {
        public DirectoryElementBuilder() {
            super(JpsDirectoryPackagingElement.class);
        }

        @Override
        public void generateInstructions(JpsDirectoryPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator.subFolder(element.getDirectoryName()), builderContext);
        }
    }

    private class RootElementBuilder
    extends LayoutElementBuilderService<JpsArtifactRootElement> {
        public RootElementBuilder() {
            super(JpsArtifactRootElement.class);
        }

        @Override
        public void generateInstructions(JpsArtifactRootElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
            LayoutElementBuildersRegistry.this.generateChildrenInstructions((JpsCompositePackagingElement)element, instructionCreator, builderContext);
        }
    }

    private static class InstanceHolder {
        static final LayoutElementBuildersRegistry ourInstance = new LayoutElementBuildersRegistry();

        private InstanceHolder() {
        }
    }
}

