/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildOutputConsumerImpl;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.TimestampStorage;

public class BuildOperations {
    private BuildOperations() {
    }

    public static void ensureFSStateInitialized(CompileContext context, BuildTarget<?> target) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        TimestampStorage timestamps = pd.timestamps.getStorage();
        BuildTargetConfiguration configuration = pd.getTargetsState().getTargetConfiguration(target);
        if (context.isProjectRebuild()) {
            FSOperations.markDirtyFiles(context, target, timestamps, true, null, null);
            pd.fsState.markInitialScanPerformed(target);
            configuration.save(context);
        } else if (context.getScope().isBuildForced(target) || configuration.isTargetDirty(context) || configuration.outputRootWasDeleted(context)) {
            BuildOperations.initTargetFSState(context, target, true);
            IncProjectBuilder.clearOutputFiles(context, target);
            pd.dataManager.cleanTargetStorages(target);
            configuration.save(context);
        } else if (!pd.fsState.isInitialScanPerformed(target)) {
            BuildOperations.initTargetFSState(context, target, false);
        }
    }

    private static void initTargetFSState(CompileContext context, BuildTarget<?> target, boolean forceMarkDirty) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        TimestampStorage timestamps = pd.timestamps.getStorage();
        THashSet currentFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        FSOperations.markDirtyFiles(context, target, timestamps, forceMarkDirty, (THashSet<File>)currentFiles, null);
        BuildFSState fsState = pd.fsState;
        fsState.clearDeletedPaths(target);
        SourceToOutputMapping sourceToOutputMap = pd.dataManager.getSourceToOutputMap(target);
        Iterator<String> it = sourceToOutputMap.getSourcesIterator();
        while (it.hasNext()) {
            String path = it.next();
            File file = new File(path);
            if (currentFiles.contains((Object)file)) continue;
            fsState.registerDeleted(target, file, timestamps);
        }
        pd.fsState.markInitialScanPerformed(target);
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> void buildTarget(final T target, final CompileContext context, TargetBuilder<?, ?> builder) throws ProjectBuildException, IOException {
        if (builder.getTargetTypes().contains(target.getTargetType())) {
            DirtyFilesHolderBase holder = new DirtyFilesHolderBase<R, T>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<R, T> processor) throws IOException {
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/BuildOperations$1", "processDirtyFiles"));
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }
            };
            BuildOutputConsumerImpl outputConsumer = new BuildOutputConsumerImpl(target, context);
            builder.build(target, holder, outputConsumer, context);
            outputConsumer.fireFileGeneratedEvent();
            context.checkCanceled();
        }
    }

    public static void markTargetsUpToDate(CompileContext context, BuildTargetChunk chunk) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        for (BuildTarget<?> target : chunk.getTargets()) {
            pd.getTargetsState().getTargetConfiguration(target).storeNonexistentOutputRoots(context);
        }
        if (!Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled()) {
            boolean marked = BuildOperations.dropRemovedPaths(context, chunk);
            for (BuildTarget<?> target : chunk.getTargets()) {
                if (target instanceof ModuleBuildTarget) {
                    context.clearNonIncrementalMark((ModuleBuildTarget)target);
                }
                TimestampStorage timestamps = pd.timestamps.getStorage();
                for (BuildRootDescriptor rd : pd.getBuildRootIndex().getTargetRoots(target, context)) {
                    marked |= fsState.markAllUpToDate(context, rd, timestamps);
                }
            }
            if (marked) {
                context.processMessage(DoneSomethingNotification.INSTANCE);
            }
        }
    }

    private static boolean dropRemovedPaths(CompileContext context, BuildTargetChunk chunk) throws IOException {
        Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
        boolean dropped = false;
        if (map != null) {
            for (BuildTarget<?> target : chunk.getTargets()) {
                Collection paths = (Collection)map.remove(target);
                if (paths == null) continue;
                SourceToOutputMapping storage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                for (String path : paths) {
                    storage.remove(path);
                    dropped = true;
                }
            }
        }
        return dropped;
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> Map<T, Set<File>> cleanOutputsCorrespondingToChangedFiles(CompileContext context, DirtyFilesHolder<R, T> dirtyFilesHolder) throws ProjectBuildException {
        final BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        try {
            ProjectBuilderLogger logger;
            final HashMap cleanedSources = new HashMap();
            final THashSet dirsToDelete = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            final ArrayList<String> deletedPaths = new ArrayList<String>();
            dirtyFilesHolder.processDirtyFiles(new FileProcessor<R, T>(){
                private final Map<T, SourceToOutputMapping> mappingsCache = new HashMap();

                @Override
                public boolean apply(T target, File file, R sourceRoot) throws IOException {
                    String srcPath;
                    Collection<String> outputs;
                    SourceToOutputMapping srcToOut = this.mappingsCache.get(target);
                    if (srcToOut == null) {
                        srcToOut = dataManager.getSourceToOutputMap((BuildTarget<?>)target);
                        this.mappingsCache.put(target, srcToOut);
                    }
                    if ((outputs = srcToOut.getOutputs(srcPath = file.getPath())) != null) {
                        boolean shouldPruneOutputDirs = target instanceof ModuleBasedTarget;
                        for (String output : outputs) {
                            BuildOperations.deleteRecursively(output, deletedPaths, (Set<File>)(shouldPruneOutputDirs ? dirsToDelete : null));
                        }
                        Set cleaned = (Set)cleanedSources.get(target);
                        if (cleaned == null) {
                            cleaned = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                            cleanedSources.put(target, cleaned);
                        }
                        cleaned.add(file);
                    }
                    return true;
                }
            });
            if (context.isMake() && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
                logger.logDeletedFiles(deletedPaths);
            }
            if (!deletedPaths.isEmpty()) {
                context.processMessage(new FileDeletedEvent(deletedPaths));
            }
            FSOperations.pruneEmptyDirs(context, (Set<File>)dirsToDelete);
            return cleanedSources;
        }
        catch (Exception e) {
            throw new ProjectBuildException(e);
        }
    }

    public static boolean deleteRecursively(@NotNull String path, @NotNull Collection<String> deletedPaths, @Nullable Set<File> parentDirs) {
        File parent;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/BuildOperations", "deleteRecursively"));
        }
        if (deletedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/BuildOperations", "deleteRecursively"));
        }
        File file = new File(path);
        boolean deleted = BuildOperations.deleteRecursively(file, deletedPaths);
        if (deleted && parentDirs != null && (parent = file.getParentFile()) != null) {
            parentDirs.add(parent);
        }
        return deleted;
    }

    private static boolean deleteRecursively(File file, Collection<String> deletedPaths) {
        boolean deleted;
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                BuildOperations.deleteRecursively(child, deletedPaths);
            }
        }
        if ((deleted = file.delete()) && children == null) {
            deletedPaths.add(FileUtil.toSystemIndependentName((String)file.getPath()));
        }
        return deleted;
    }
}

