/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.google.protobuf.Message;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.jgoodies.forms.layout.CellConstraints;
import io.netty.util.NetUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import jsr166e.extra.SequenceLock;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.javac.JavacServer;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsModelImpl;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class ClasspathBootstrap {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.ClasspathBootstrap");

    private ClasspathBootstrap() {
    }

    public static List<String> getBuildProcessApplicationClasspath(boolean isLauncherUsed) {
        HashSet cp = ContainerUtil.newHashSet();
        cp.add(ClasspathBootstrap.getResourcePath(BuildMain.class));
        cp.addAll(PathManager.getUtilClassPath());
        cp.add(ClasspathBootstrap.getResourcePath(Message.class));
        cp.add(ClasspathBootstrap.getResourcePath(NetUtil.class));
        cp.add(ClasspathBootstrap.getResourcePath(ClassWriter.class));
        cp.add(ClasspathBootstrap.getResourcePath(ClassVisitor.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsModel.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsModelImpl.class));
        cp.add(ClasspathBootstrap.getResourcePath(JpsProjectLoader.class));
        cp.add(ClasspathBootstrap.getResourcePath(AlienFormFileException.class));
        cp.add(ClasspathBootstrap.getResourcePath(GridConstraints.class));
        cp.add(ClasspathBootstrap.getResourcePath(CellConstraints.class));
        cp.add(ClasspathBootstrap.getResourcePath(NotNullVerifyingInstrumenter.class));
        cp.add(ClasspathBootstrap.getResourcePath(IXMLBuilder.class));
        cp.add(ClasspathBootstrap.getResourcePath(SequenceLock.class));
        if (!isLauncherUsed) {
            ClasspathBootstrap.appendJavaCompilerClasspath(cp);
        }
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourcePath(cmdLineWrapper));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ContainerUtil.newArrayList((Iterable)cp);
    }

    public static void appendJavaCompilerClasspath(Collection<String> cp) {
        Class<StandardJavaFileManager> optimizedFileManagerClass = ClasspathBootstrap.getOptimizedFileManagerClass();
        if (optimizedFileManagerClass != null) {
            cp.add(ClasspathBootstrap.getResourcePath(optimizedFileManagerClass));
        }
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            String compilerResource = ClasspathBootstrap.getResourcePath(javaCompiler.getClass());
            String name = PathUtilRt.getFileName((String)compilerResource);
            if (!name.startsWith("ecj-") || !name.endsWith(".jar")) continue;
            cp.add(compilerResource);
        }
    }

    public static List<File> getJavacServerClasspath(String sdkHome, JavaCompilingTool compilingTool) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        cp.add(ClasspathBootstrap.getResourceFile(JavacServer.class));
        for (String path : PathManager.getUtilClassPath()) {
            cp.add(new File(path));
        }
        cp.add(ClasspathBootstrap.getResourceFile(JpsModel.class));
        cp.add(ClasspathBootstrap.getResourceFile(JpsModelImpl.class));
        cp.add(ClasspathBootstrap.getResourceFile(Message.class));
        cp.add(ClasspathBootstrap.getResourceFile(NetUtil.class));
        Class<StandardJavaFileManager> optimizedFileManagerClass = ClasspathBootstrap.getOptimizedFileManagerClass();
        if (optimizedFileManagerClass != null) {
            cp.add(ClasspathBootstrap.getResourceFile(optimizedFileManagerClass));
        }
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourceFile(cmdLineWrapper));
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
        if (systemCompiler != null) {
            try {
                String localJarPath = FileUtil.toSystemIndependentName((String)ClasspathBootstrap.getResourceFile(systemCompiler.getClass()).getPath());
                String localJavaHome = FileUtil.toSystemIndependentName((String)SystemProperties.getJavaHome());
                if (FileUtil.pathsEqual((String)localJavaHome, (String)FileUtil.toSystemIndependentName((String)sdkHome))) {
                    cp.add(new File(localJarPath));
                } else {
                    File candidate = new File(sdkHome, "lib/tools.jar");
                    if (candidate.exists()) {
                        cp.add(candidate);
                    } else {
                        String relPath = FileUtil.getRelativePath((String)localJavaHome, (String)localJarPath, (char)'/');
                        if (relPath != null) {
                            if (relPath.contains("..")) {
                                relPath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)new File(localJavaHome).getParent()), (String)localJarPath, (char)'/');
                            }
                            if (relPath != null) {
                                File targetFile = new File(sdkHome, relPath);
                                cp.add(targetFile);
                            }
                        }
                    }
                }
            }
            catch (Throwable th) {
                LOG.info(th);
            }
        }
        cp.addAll(compilingTool.getAdditionalClasspath());
        Class<JavaSourceTransformer> transformerClass = JavaSourceTransformer.class;
        ServiceLoader<JavaSourceTransformer> loader = ServiceLoader.load(transformerClass, transformerClass.getClassLoader());
        for (JavaSourceTransformer t : loader) {
            cp.add(ClasspathBootstrap.getResourceFile(t.getClass()));
        }
        return new ArrayList<File>(cp);
    }

    @Nullable
    public static Class<StandardJavaFileManager> getOptimizedFileManagerClass() {
        Class<StandardJavaFileManager> aClass = OptimizedFileManagerClassHolder.managerClass;
        if (aClass != null) {
            return aClass;
        }
        return OptimizedFileManager17ClassHolder.managerClass;
    }

    @Nullable
    public static Method getOptimizedFileManagerCacheClearMethod() {
        Method method = OptimizedFileManagerClassHolder.directoryCacheClearMethod;
        if (method != null) {
            return method;
        }
        return OptimizedFileManager17ClassHolder.directoryCacheClearMethod;
    }

    @Nullable
    public static String getOptimizedFileManagerLoadError() {
        StringBuilder builder = new StringBuilder();
        if (OptimizedFileManagerClassHolder.initError != null) {
            builder.append(OptimizedFileManagerClassHolder.initError);
        }
        if (OptimizedFileManager17ClassHolder.initError != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(OptimizedFileManager17ClassHolder.initError);
        }
        return builder.toString();
    }

    public static String getResourcePath(Class aClass) {
        return PathManager.getResourceRoot((Class)aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
    }

    public static File getResourceFile(Class aClass) {
        return new File(ClasspathBootstrap.getResourcePath(aClass));
    }

    private static class OptimizedFileManager17ClassHolder {
        static final String CLASS_NAME = "org.jetbrains.jps.javac.OptimizedFileManager17";
        @Nullable
        static final Class<StandardJavaFileManager> managerClass;
        static final Method directoryCacheClearMethod;
        @Nullable
        static final String initError;

        private OptimizedFileManager17ClassHolder() {
        }

        static {
            Class<?> aClass;
            Method cacheClearMethod = null;
            String error = null;
            try {
                Class<?> c;
                aClass = c = Class.forName(CLASS_NAME);
                try {
                    cacheClearMethod = c.getMethod("fileGenerated", File.class);
                    cacheClearMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    LOG.info((Throwable)e);
                }
            }
            catch (Throwable ex) {
                aClass = null;
                error = ex.getClass().getName() + ": " + ex.getMessage();
            }
            managerClass = aClass;
            directoryCacheClearMethod = cacheClearMethod;
            initError = error;
        }
    }

    private static class OptimizedFileManagerClassHolder {
        static final String CLASS_NAME = "org.jetbrains.jps.javac.OptimizedFileManager";
        @Nullable
        static final Class<StandardJavaFileManager> managerClass;
        static final Method directoryCacheClearMethod;
        @Nullable
        static final String initError;

        private OptimizedFileManagerClassHolder() {
        }

        static {
            Class<?> aClass = null;
            Method cacheClearMethod = null;
            String error = null;
            try {
                Class<?> c;
                aClass = c = Class.forName(CLASS_NAME);
                try {
                    cacheClearMethod = c.getMethod("fileGenerated", File.class);
                    cacheClearMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    LOG.info((Throwable)e);
                }
            }
            catch (Throwable ex) {
                aClass = null;
                error = ex.getClass().getName() + ": " + ex.getMessage();
            }
            managerClass = aClass;
            directoryCacheClearMethod = cacheClearMethod;
            initError = error;
        }
    }
}

