/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.org.objectweb.asm.Type;

class UsageRepr {
    private static final byte FIELD_USAGE = 0;
    private static final byte FIELD_ASSIGN_USAGE = 1;
    private static final byte METHOD_USAGE = 2;
    private static final byte CLASS_USAGE = 3;
    private static final byte CLASS_EXTENDS_USAGE = 4;
    private static final byte CLASS_NEW_USAGE = 5;
    private static final byte ANNOTATION_USAGE = 6;
    private static final byte METAMETHOD_USAGE = 7;
    private static final byte CLASS_AS_GENERIC_BOUND_USAGE = 8;
    private static final int DEFAULT_SET_CAPACITY = 32;
    private static final float DEFAULT_SET_LOAD_FACTOR = 0.98f;

    private UsageRepr() {
    }

    public static Usage createFieldUsage(DependencyContext context, int name, int owner, int descr) {
        return context.getUsage(new FieldUsage(context, name, owner, descr));
    }

    public static Usage createFieldAssignUsage(DependencyContext context, int name, int owner, int descr) {
        return context.getUsage(new FieldAssignUsage(context, name, owner, descr));
    }

    public static Usage createMethodUsage(DependencyContext context, int name, int owner, String descr) {
        return context.getUsage(new MethodUsage(context, name, owner, descr));
    }

    public static Usage createMetaMethodUsage(DependencyContext context, int name, int owner, String descr) {
        return context.getUsage(new MetaMethodUsage(context, name, owner, descr));
    }

    public static Usage createClassUsage(DependencyContext context, int name) {
        return context.getUsage(new ClassUsage(name));
    }

    public static Usage createClassAsGenericBoundUsage(DependencyContext context, int name) {
        return context.getUsage(new ClassAsGenericBoundUsage(name));
    }

    public static Usage createClassNewUsage(DependencyContext context, int name) {
        return context.getUsage(new ClassNewUsage(name));
    }

    public static Usage createAnnotationUsage(DependencyContext context, TypeRepr.ClassType type, TIntHashSet usedArguments, Set<ElemType> targets) {
        return context.getUsage(new AnnotationUsage(type, usedArguments, targets));
    }

    public static DataExternalizer<Usage> externalizer(final DependencyContext context) {
        return new DataExternalizer<Usage>(){

            public void save(@NotNull DataOutput out, Usage value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/dependencyView/UsageRepr$1", "save"));
                }
                value.save(out);
            }

            public Usage read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/dependencyView/UsageRepr$1", "read"));
                }
                byte tag = in.readByte();
                switch (tag) {
                    case 3: {
                        return context.getUsage(new ClassUsage(in));
                    }
                    case 8: {
                        return context.getUsage(new ClassAsGenericBoundUsage(in));
                    }
                    case 4: {
                        return context.getUsage(new ClassExtendsUsage(in));
                    }
                    case 5: {
                        return context.getUsage(new ClassNewUsage(in));
                    }
                    case 0: {
                        return context.getUsage(new FieldUsage(context, in));
                    }
                    case 1: {
                        return context.getUsage(new FieldAssignUsage(context, in));
                    }
                    case 2: {
                        return context.getUsage(new MethodUsage(context, in));
                    }
                    case 6: {
                        return context.getUsage(new AnnotationUsage(context, in));
                    }
                    case 7: {
                        return context.getUsage(new MetaMethodUsage(in));
                    }
                }
                assert (false);
                return null;
            }
        };
    }

    public static class AnnotationUsage
    extends Usage {
        public static final DataExternalizer<ElemType> elementTypeExternalizer = new DataExternalizer<ElemType>(){

            public void save(@NotNull DataOutput out, ElemType value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/dependencyView/UsageRepr$AnnotationUsage$1", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.ordinal());
            }

            public ElemType read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/dependencyView/UsageRepr$AnnotationUsage$1", "read"));
                }
                int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                for (ElemType value : ElemType.values()) {
                    if (value.ordinal() != ordinal) continue;
                    return value;
                }
                throw new IOException("Error reading ElementType enum value; unknown ordinal: " + ordinal);
            }
        };
        final TypeRepr.ClassType myType;
        final TIntHashSet myUsedArguments;
        final Set<ElemType> myUsedTargets;

        public boolean satisfies(Usage usage) {
            if (usage instanceof AnnotationUsage) {
                AnnotationUsage annotationUsage = (AnnotationUsage)usage;
                if (!this.myType.equals(annotationUsage.myType)) {
                    return false;
                }
                boolean argumentsSatisfy = false;
                if (this.myUsedArguments != null) {
                    TIntHashSet arguments = new TIntHashSet(this.myUsedArguments.toArray());
                    arguments.removeAll(annotationUsage.myUsedArguments.toArray());
                    argumentsSatisfy = !arguments.isEmpty();
                }
                boolean targetsSatisfy = false;
                if (this.myUsedTargets != null) {
                    EnumSet<ElemType> targets = EnumSet.copyOf(this.myUsedTargets);
                    targets.retainAll(annotationUsage.myUsedTargets);
                    targetsSatisfy = !targets.isEmpty();
                }
                return argumentsSatisfy || targetsSatisfy;
            }
            return false;
        }

        private AnnotationUsage(TypeRepr.ClassType type, TIntHashSet usedArguments, Set<ElemType> targets) {
            this.myType = type;
            this.myUsedArguments = usedArguments;
            this.myUsedTargets = targets;
        }

        private AnnotationUsage(DependencyContext context, DataInput in) {
            DataExternalizer<TypeRepr.AbstractType> externalizer = TypeRepr.externalizer(context);
            try {
                this.myType = (TypeRepr.ClassType)externalizer.read(in);
                this.myUsedArguments = RW.read(new TIntHashSet(32, 0.98f), in);
                this.myUsedTargets = (EnumSet)RW.read(elementTypeExternalizer, EnumSet.noneOf(ElemType.class), in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(6);
                this.myType.save(out);
                RW.save(this.myUsedArguments, out);
                RW.save(this.myUsedTargets, elementTypeExternalizer, out);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public int getOwner() {
            return this.myType.className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationUsage that = (AnnotationUsage)o;
            if (this.myUsedArguments != null ? !this.myUsedArguments.equals((Object)that.myUsedArguments) : that.myUsedArguments != null) {
                return false;
            }
            if (this.myUsedTargets != null ? !((Object)this.myUsedTargets).equals(that.myUsedTargets) : that.myUsedTargets != null) {
                return false;
            }
            return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + (this.myUsedArguments != null ? this.myUsedArguments.hashCode() : 0);
            result = 31 * result + (this.myUsedTargets != null ? ((Object)this.myUsedTargets).hashCode() : 0);
            return result;
        }

        @Override
        public void toStream(final DependencyContext context, PrintStream stream) {
            stream.println("    AnnotationUsage:");
            stream.println("      Type     : " + this.myType.getDescr(context));
            final LinkedList arguments = new LinkedList();
            if (this.myUsedArguments != null) {
                this.myUsedArguments.forEach(new TIntProcedure(){

                    public boolean execute(int value) {
                        arguments.add(context.getValue(value));
                        return true;
                    }
                });
            }
            Collections.sort(arguments);
            LinkedList<String> targets = new LinkedList<String>();
            if (this.myUsedTargets != null) {
                for (ElemType e : this.myUsedTargets) {
                    targets.add(e.toString());
                }
            }
            Collections.sort(targets);
            stream.println("      Arguments:");
            for (String s : arguments) {
                stream.println("        " + s);
            }
            stream.println("      Targets  :");
            for (String s : targets) {
                stream.println("        " + s);
            }
        }
    }

    public static class ClassNewUsage
    extends ClassExtendsUsage {
        public ClassNewUsage(int className) {
            super(className);
        }

        private ClassNewUsage(DataInput in) {
            super(in);
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(5);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myClassName);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public int hashCode() {
            return this.myClassName + 2;
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            stream.println("ClassNewUsage: " + context.getValue(this.myClassName));
        }
    }

    public static class ClassExtendsUsage
    extends Usage {
        protected final int myClassName;

        @Override
        public int getOwner() {
            return this.myClassName;
        }

        private ClassExtendsUsage(int className) {
            this.myClassName = className;
        }

        private ClassExtendsUsage(DataInput in) {
            try {
                this.myClassName = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(4);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myClassName);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public int hashCode() {
            return this.myClassName + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassExtendsUsage that = (ClassExtendsUsage)o;
            return this.myClassName == that.myClassName;
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            stream.println("ClassExtendsUsage: " + context.getValue(this.myClassName));
        }
    }

    public static class ClassAsGenericBoundUsage
    extends ClassUsage {
        public ClassAsGenericBoundUsage(int className) {
            super(className);
        }

        public ClassAsGenericBoundUsage(DataInput in) {
            super(in);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 3;
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(8);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myClassName);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            stream.println("ClassAsGenericBoundUsage: " + context.getValue(this.myClassName));
        }
    }

    public static class ClassUsage
    extends Usage {
        final int myClassName;

        @Override
        public int getOwner() {
            return this.myClassName;
        }

        private ClassUsage(int className) {
            this.myClassName = className;
        }

        private ClassUsage(DataInput in) {
            try {
                this.myClassName = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void save(DataOutput out) {
            try {
                out.writeByte(3);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myClassName);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassUsage that = (ClassUsage)o;
            return this.myClassName == that.myClassName;
        }

        public int hashCode() {
            return this.myClassName;
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            stream.println("ClassUsage: " + context.getValue(this.myClassName));
        }
    }

    public static class MetaMethodUsage
    extends FMUsage {
        private int myArity;

        public MetaMethodUsage(DependencyContext context, int n, int o, String descr) {
            super(n, o);
            this.myArity = TypeRepr.getType(context, Type.getArgumentTypes((String)descr)).length;
        }

        public MetaMethodUsage(DataInput in) {
            super(in);
            try {
                this.myArity = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void save(DataOutput out) {
            this.save((byte)7, out);
            try {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myArity);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MetaMethodUsage that = (MetaMethodUsage)o;
            if (this.myArity != that.myArity) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myArity;
            return result;
        }

        @Override
        void kindToStream(PrintStream stream) {
            stream.println("MetaMethodUsage:");
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            super.toStream(context, stream);
            stream.println("          Arity: " + Integer.toString(this.myArity));
        }
    }

    public static class MethodUsage
    extends FMUsage {
        public final TypeRepr.AbstractType[] myArgumentTypes;
        public final TypeRepr.AbstractType myReturnType;

        private MethodUsage(DependencyContext context, int name, int owner, String descriptor) {
            super(name, owner);
            this.myArgumentTypes = TypeRepr.getType(context, Type.getArgumentTypes((String)descriptor));
            this.myReturnType = TypeRepr.getType(context, Type.getReturnType((String)descriptor));
        }

        private MethodUsage(DependencyContext context, DataInput in) {
            super(in);
            try {
                DataExternalizer<TypeRepr.AbstractType> externalizer = TypeRepr.externalizer(context);
                int argumentTypes = DataInputOutputUtil.readINT((DataInput)in);
                this.myArgumentTypes = RW.read(externalizer, in, argumentTypes != 0 ? new TypeRepr.AbstractType[argumentTypes] : TypeRepr.AbstractType.EMPTY_TYPE_ARRAY);
                this.myReturnType = (TypeRepr.AbstractType)externalizer.read(in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        public void save(DataOutput out) {
            this.save((byte)2, out);
            RW.save((RW.Savable[])this.myArgumentTypes, (DataOutput)out);
            this.myReturnType.save(out);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodUsage that = (MethodUsage)o;
            if (!Arrays.equals(this.myArgumentTypes, that.myArgumentTypes)) {
                return false;
            }
            if (this.myReturnType != null ? !this.myReturnType.equals(that.myReturnType) : that.myReturnType != null) {
                return false;
            }
            if (this.myName != that.myName) {
                return false;
            }
            if (this.myOwner != that.myOwner) {
                return false;
            }
            return Arrays.equals(this.myArgumentTypes, that.myArgumentTypes) && this.myReturnType.equals(that.myReturnType) && this.myName == that.myName && this.myOwner == that.myOwner;
        }

        @Override
        public int hashCode() {
            return ((31 * Arrays.hashCode(this.myArgumentTypes) + this.myReturnType.hashCode()) * 31 + this.myName) * 31 + this.myOwner;
        }

        @Override
        void kindToStream(PrintStream stream) {
            stream.println("MethodUsage:");
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            super.toStream(context, stream);
            stream.println("          Arguments:");
            for (TypeRepr.AbstractType at : this.myArgumentTypes) {
                stream.println("            " + at.getDescr(context));
            }
            stream.println("          Return type:");
            stream.println("            " + this.myReturnType.getDescr(context));
        }
    }

    public static class FieldAssignUsage
    extends FieldUsage {
        private FieldAssignUsage(DependencyContext context, int n, int o, int d) {
            super(context, n, o, d);
        }

        private FieldAssignUsage(DependencyContext context, DataInput in) {
            super(context, in);
        }

        @Override
        protected void kindToStream(PrintStream stream) {
            stream.println("FieldAssignUsage:");
        }

        @Override
        public void save(DataOutput out) {
            this.save((byte)1, out);
            this.myType.save(out);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldAssignUsage that = (FieldAssignUsage)o;
            return this.myType.equals(that.myType) && this.myName == that.myName && this.myOwner == that.myOwner;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1;
        }
    }

    public static class FieldUsage
    extends FMUsage {
        public final TypeRepr.AbstractType myType;

        private FieldUsage(DependencyContext context, int name, int owner, int descriptor) {
            super(name, owner);
            this.myType = TypeRepr.getType(context, descriptor);
        }

        private FieldUsage(DependencyContext context, DataInput in) {
            super(in);
            try {
                this.myType = (TypeRepr.AbstractType)TypeRepr.externalizer(context).read(in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        @Override
        protected void kindToStream(PrintStream stream) {
            stream.println("FieldUsage:");
        }

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            super.toStream(context, stream);
            stream.println("          Type: " + this.myType.getDescr(context));
        }

        @Override
        public void save(DataOutput out) {
            this.save((byte)0, out);
            this.myType.save(out);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldUsage that = (FieldUsage)o;
            return this.myType.equals(that.myType) && this.myName == that.myName && this.myOwner == that.myOwner;
        }

        @Override
        public int hashCode() {
            return 31 * (31 * this.myType.hashCode() + this.myName) + this.myOwner;
        }
    }

    public static abstract class FMUsage
    extends Usage {
        public final int myName;
        public final int myOwner;

        abstract void kindToStream(PrintStream var1);

        @Override
        public void toStream(DependencyContext context, PrintStream stream) {
            this.kindToStream(stream);
            stream.println("          Name : " + context.getValue(this.myName));
            stream.println("          Owner: " + context.getValue(this.myOwner));
        }

        @Override
        public int getOwner() {
            return this.myOwner;
        }

        private FMUsage(int name, int owner) {
            this.myName = name;
            this.myOwner = owner;
        }

        private FMUsage(DataInput in) {
            try {
                this.myName = DataInputOutputUtil.readINT((DataInput)in);
                this.myOwner = DataInputOutputUtil.readINT((DataInput)in);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        protected final void save(byte tag, DataOutput out) {
            try {
                out.writeByte(tag);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myName);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOwner);
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FMUsage fmUsage = (FMUsage)o;
            if (this.myName != fmUsage.myName) {
                return false;
            }
            return this.myOwner == fmUsage.myOwner;
        }

        public int hashCode() {
            return 31 * this.myName + this.myOwner;
        }
    }

    public static abstract class Usage
    implements RW.Savable,
    Streamable {
        public abstract int getOwner();
    }
}

