/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class RW {
    private static final byte[] ourStringBuffer = IOUtil.allocReadWriteUTFBuffer();
    public static ToWritable<String> fromString = new ToWritable<String>(){

        @Override
        public Writable convert(final String s) {
            return new Writable(){

                @Override
                public void write(BufferedWriter w) {
                    RW.writeln(w, s);
                }
            };
        }
    };

    private RW() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readUTF(DataInput in) throws IOException {
        byte[] byArray = ourStringBuffer;
        synchronized (ourStringBuffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return IOUtil.readUTFFast((byte[])ourStringBuffer, (DataInput)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeUTF(DataOutput out, String value) throws IOException {
        byte[] byArray = ourStringBuffer;
        synchronized (ourStringBuffer) {
            IOUtil.writeUTFFast((byte[])ourStringBuffer, (DataOutput)out, (String)value);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static <X extends Savable> void save(X[] x, DataOutput out) {
        try {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)x.length);
            for (X s : x) {
                s.save(out);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public static <X> void save(TIntHashSet x, final DataOutput out) {
        try {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)x.size());
            x.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
                        return true;
                    }
                    catch (IOException e) {
                        throw new BuildDataCorruptedException(e);
                    }
                }
            });
        }
        catch (IOException c) {
            throw new BuildDataCorruptedException(c);
        }
    }

    public static <X> void save(Collection<X> x, DataExternalizer<X> e, DataOutput out) {
        try {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)x.size());
            for (X y : x) {
                e.save(out, y);
            }
        }
        catch (IOException c) {
            throw new BuildDataCorruptedException(c);
        }
    }

    public static <X extends Savable> void save(Collection<X> x, DataOutput out) {
        try {
            int size = x.size();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (Savable s : x) {
                s.save(out);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public static <X> X[] read(DataExternalizer<X> e, DataInput in, X[] result) {
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = e.read(in);
            }
            return result;
        }
        catch (IOException x) {
            throw new BuildDataCorruptedException(x);
        }
    }

    public static TIntHashSet read(TIntHashSet acc, DataInput in) {
        try {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                acc.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return acc;
        }
        catch (IOException x) {
            throw new BuildDataCorruptedException(x);
        }
    }

    public static <X> Collection<X> read(DataExternalizer<X> e, Collection<X> acc, DataInput in) {
        try {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                acc.add(e.read(in));
            }
            return acc;
        }
        catch (IOException x) {
            throw new BuildDataCorruptedException(x);
        }
    }

    public static void writeln(BufferedWriter w, String s) {
        try {
            if (s == null) {
                w.write("");
            } else {
                w.write(s);
            }
            w.newLine();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public static String readString(BufferedReader r) {
        try {
            return r.readLine();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public static long readLong(BufferedReader r) {
        String s = RW.readString(r);
        try {
            return Long.parseLong(s);
        }
        catch (Exception n) {
            System.err.println("Parsing error: expected long, but found \"" + s + "\"");
            return 0L;
        }
    }

    public static interface Reader<T> {
        public T read(BufferedReader var1);
    }

    public static interface ToWritable<T> {
        public Writable convert(T var1);
    }

    public static interface Writable {
        public void write(BufferedWriter var1);
    }

    public static interface Savable {
        public void save(DataOutput var1);
    }
}

