/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;

public final class FilteredResourceRootDescriptor
extends ResourceRootDescriptor {
    public FilteredResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/FilteredResourceRootDescriptor", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/java/FilteredResourceRootDescriptor", "<init>"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/builders/java/FilteredResourceRootDescriptor", "<init>"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/builders/java/FilteredResourceRootDescriptor", "<init>"));
        }
        super(root, target, packagePrefix, excludes);
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        final JpsCompilerExcludes excludes = configuration.getCompilerExcludes();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !excludes.isExcluded(file) && configuration.isResourceFile(file, FilteredResourceRootDescriptor.this.getRootFile());
            }
        };
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/FilteredResourceRootDescriptor", "createFileFilter"));
        }
        return fileFilter;
    }
}

